/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.midnightcontrols.ControlsMode;
import eu.midnightdust.midnightcontrols.MidnightControlsFeature;
import eu.midnightdust.midnightcontrols.client.ControllerType;
import eu.midnightdust.midnightcontrols.client.HudSide;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.VirtualMouseSkin;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.Controller;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_4494;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MidnightControlsConfig
extends MidnightConfig {
    public static boolean isEditing = false;
    @MidnightConfig.Hidden
    @MidnightConfig.Entry
    public static int configVersion = 2;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.controls_mode")
    public static ControlsMode controlsMode = ControlsMode.DEFAULT;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.auto_switch_mode")
    public static boolean autoSwitchMode = true;
    @MidnightConfig.Entry(category="misc", name="Debug")
    public static boolean debug = false;
    @MidnightConfig.Entry(category="visual", name="midnightcontrols.menu.hud_enable")
    public static boolean hudEnable = true;
    @MidnightConfig.Entry(category="visual", name="midnightcontrols.menu.hud_side")
    public static HudSide hudSide = HudSide.LEFT;
    @MidnightConfig.Entry(category="screens", name="midnightcontrols.menu.move_chat")
    public static boolean moveChat = false;
    @MidnightConfig.Entry(category="gameplay", name="midnightcontrols.menu.analog_movement")
    public static boolean analogMovement = true;
    @MidnightConfig.Entry(category="gameplay", name="midnightcontrols.menu.double_tap_to_sprint")
    public static boolean doubleTapToSprint = true;
    @MidnightConfig.Entry(category="gameplay", name="midnightcontrols.menu.controller_toggle_sneak")
    public static boolean controllerToggleSneak = (Boolean)class_310.method_1551().field_1690.method_42449().method_41753();
    @MidnightConfig.Entry(category="gameplay", name="midnightcontrols.menu.controller_toggle_sprint")
    public static boolean controllerToggleSprint = (Boolean)class_310.method_1551().field_1690.method_42450().method_41753();
    @MidnightConfig.Entry(category="gameplay", name="midnightcontrols.menu.fast_block_placing")
    public static boolean fastBlockPlacing = false;
    @MidnightConfig.Entry(category="gameplay", name="midnightcontrols.menu.fly_drifting")
    public static boolean flyDrifting = true;
    @MidnightConfig.Entry(category="gameplay", name="midnightcontrols.menu.fly_drifting_vertical")
    public static boolean verticalFlyDrifting = true;
    @MidnightConfig.Entry(category="gameplay", name="midnightcontrols.menu.reacharound.horizontal")
    public static boolean horizontalReacharound = false;
    @MidnightConfig.Entry(category="gameplay", name="midnightcontrols.menu.reacharound.vertical")
    public static boolean verticalReacharound = false;
    @MidnightConfig.Entry(category="visual", name="Reacharound Outline")
    public static boolean shouldRenderReacharoundOutline = true;
    @MidnightConfig.Entry(category="visual", name="Reacharound Outline Color", isColor=true)
    public static String reacharoundOutlineColorHex = "#ffffff";
    @MidnightConfig.Entry(category="visual", name="Reacharound Outline Alpha", isSlider=true, min=0.0, max=255.0)
    public static int reacharoundOutlineColorAlpha = 102;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.right_dead_zone", isSlider=true, min=0.05, max=1.0)
    public static double rightDeadZone = 0.25;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.left_dead_zone", isSlider=true, min=0.05, max=1.0)
    public static double leftDeadZone = 0.25;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.invert_right_y_axis")
    public static boolean invertRightYAxis = false;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.invert_right_x_axis")
    public static boolean invertRightXAxis = false;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.rotation_speed", isSlider=true, min=0.0, max=100.0, precision=10)
    public static double rotationSpeed;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.y_axis_rotation_speed", isSlider=true, min=0.0, max=100.0, precision=10)
    public static double yAxisRotationSpeed;
    @MidnightConfig.Entry(category="screens", name="midnightcontrols.menu.mouse_speed", isSlider=true, min=0.0, max=150.0, precision=10)
    public static double mouseSpeed;
    @MidnightConfig.Entry(category="screens", name="midnightcontrols.menu.joystick_as_mouse")
    public static boolean joystickAsMouse;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.unfocused_input")
    public static boolean unfocusedInput;
    @MidnightConfig.Entry(category="screens", name="midnightcontrols.menu.virtual_mouse")
    public static boolean virtualMouse;
    @MidnightConfig.Entry(category="screens", name="midnightcontrols.menu.virtual_mouse.skin")
    public static VirtualMouseSkin virtualMouseSkin;
    @MidnightConfig.Entry(category="screens", name="midnightcontrols.menu.hide_cursor")
    public static boolean hideNormalMouse;
    @MidnightConfig.Entry(category="controller", name="Controller ID")
    @MidnightConfig.Hidden
    public static Object controllerID;
    @MidnightConfig.Entry(category="controller", name="2nd Controller ID")
    @MidnightConfig.Hidden
    public static Object secondControllerID;
    @MidnightConfig.Entry(category="visual", name="midnightcontrols.menu.controller_type")
    public static ControllerType controllerType;
    @MidnightConfig.Entry(category="screens", name="Mouse screens")
    public static List<String> mouseScreens;
    @MidnightConfig.Entry(category="screens", name="Arrow screens")
    public static List<String> arrowScreens;
    @MidnightConfig.Entry(category="screens", name="WASD screens")
    public static List<String> wasdScreens;
    @MidnightConfig.Entry
    @MidnightConfig.Hidden
    public static Map<String, String> BINDING;
    private static final Pattern BUTTON_BINDING_PATTERN;
    @Deprecated
    @MidnightConfig.Hidden
    @MidnightConfig.Entry
    public static double[] maxAnalogValues;
    @MidnightConfig.Entry(category="controller", name="Max analog value: Left X", isSlider=true, min=0.25, max=1.0)
    public static double maxAnalogValueLeftX;
    @MidnightConfig.Entry(category="controller", name="Max analog value: Left Y", isSlider=true, min=0.25, max=1.0)
    public static double maxAnalogValueLeftY;
    @MidnightConfig.Entry(category="controller", name="Max analog value: Right X", isSlider=true, min=0.25, max=1.0)
    public static double maxAnalogValueRightX;
    @MidnightConfig.Entry(category="controller", name="Max analog value: Right Y", isSlider=true, min=0.25, max=1.0)
    public static double maxAnalogValueRightY;
    @MidnightConfig.Entry(category="controller", name="Trigger button fix")
    public static boolean triggerFix;
    @MidnightConfig.Entry(category="gameplay", name="Enable Hints")
    public static boolean enableHints;
    @MidnightConfig.Entry(category="screens", name="Enable Shortcut in Controls Options")
    public static boolean shortcutInControls;
    @MidnightConfig.Entry(category="misc", name="Ring Bindings (WIP)")
    public static List<String> ringBindings;
    @MidnightConfig.Entry(category="misc", name="Ignored Unbound Keys")
    public static List<String> ignoredUnboundKeys;
    @MidnightConfig.Entry
    @MidnightConfig.Hidden
    public static Map<String, Map<String, String>> controllerBindingProfiles;
    private static Map<String, String> currentBindingProfile;
    private static Controller prevController;

    public static void load() {
        MidnightControlsConfig.init((String)"midnightcontrols", MidnightControlsConfig.class);
        MidnightControlsClient.get().log("Configuration loaded.");
        InputManager.loadButtonBindings();
    }

    public static void save() {
        MidnightControlsConfig.write((String)"midnightcontrols");
        MidnightControlsClient.get().log("Configuration saved.");
        MidnightControlsFeature.refreshEnabled();
    }

    public static void updateBindingsForController(Controller controller) {
        currentBindingProfile = controller.isConnected() && controller.isGamepad() && controllerBindingProfiles.containsKey(controller.getGuid()) ? controllerBindingProfiles.get(controller.getGuid()) : Maps.newHashMap(BINDING);
        InputManager.loadButtonBindings();
    }

    public static Map<String, String> getBindingsForController() {
        return currentBindingProfile;
    }

    public static Controller getController() {
        Object raw = controllerID;
        Controller controller = Controller.byId(0);
        if (raw instanceof Number) {
            controller = Controller.byId(((Number)raw).intValue());
        } else if (raw instanceof String) {
            controller = Controller.byGuid((String)raw).orElse(Controller.byId(0));
        }
        if (!(controller.isConnected() && controller.isGamepad() || !autoSwitchMode || isEditing)) {
            for (int i = 0; i < 15; ++i) {
                Controller gamepad = Controller.byId(i);
                if (!gamepad.isConnected() || !gamepad.isGamepad()) continue;
                controller = gamepad;
                i = 15;
            }
        }
        if (controller.isConnected() && controller.isGamepad() && autoSwitchMode && !isEditing) {
            controlsMode = ControlsMode.CONTROLLER;
        }
        if (prevController != controller) {
            MidnightControlsConfig.updateBindingsForController(controller);
        }
        prevController = controller;
        return controller;
    }

    public static void setController(Controller controller) {
        controllerID = controller.id();
        MidnightControlsConfig.write((String)"midnightcontrols");
    }

    public static Optional<Controller> getSecondController() {
        Object raw = secondControllerID;
        if (raw instanceof Number) {
            if (((Number)raw).intValue() == -1) {
                return Optional.empty();
            }
            return Optional.of(Controller.byId(((Number)raw).intValue()));
        }
        if (raw instanceof String) {
            return Optional.of(Controller.byGuid((String)raw).orElse(Controller.byId(0)));
        }
        return Optional.empty();
    }

    public static void setSecondController(@Nullable Controller controller) {
        secondControllerID = controller == null ? -1 : controller.id();
    }

    public static double getRightXAxisSign() {
        return invertRightXAxis ? -1.0 : 1.0;
    }

    public static double getRightYAxisSign() {
        return invertRightYAxis ? -1.0 : 1.0;
    }

    public static double getAxisMaxValue(int axis) {
        return switch (axis) {
            case 0 -> maxAnalogValueLeftX;
            case 1 -> maxAnalogValueLeftY;
            case 2 -> maxAnalogValueRightX;
            default -> maxAnalogValueRightY;
        };
    }

    public static void setAxisMaxValue(int axis, double value) {
        switch (axis) {
            case 0: {
                maxAnalogValueLeftX = value;
                break;
            }
            case 1: {
                maxAnalogValueLeftY = value;
                break;
            }
            case 2: {
                maxAnalogValueRightX = value;
                break;
            }
            default: {
                maxAnalogValueRightY = value;
            }
        }
    }

    public static void loadButtonBinding(@NotNull ButtonBinding button) {
        button.setButton(button.getDefaultButton());
        String code = MidnightControlsConfig.getBindingsForController().getOrDefault("controller.controls." + button.getName(), button.getButtonCode());
        Matcher matcher = BUTTON_BINDING_PATTERN.matcher(code);
        try {
            int[] buttons = new int[1];
            int count = 0;
            while (matcher.find()) {
                String current;
                if (++count > buttons.length) {
                    buttons = Arrays.copyOf(buttons, count);
                }
                if (!MidnightControlsConfig.checkValidity(button, code, current = matcher.group(1))) {
                    return;
                }
                buttons[count - 1] = Integer.parseInt(current);
            }
            if (count == 0) {
                MidnightControlsClient.get().warn("Malformed config value \"" + code + "\" for binding \"" + button.getName() + "\".");
                MidnightControlsConfig.setButtonBinding(button, new int[]{-1});
            }
            button.setButton(buttons);
        }
        catch (Exception e) {
            MidnightControlsClient.get().warn("Malformed config value \"" + code + "\" for binding \"" + button.getName() + "\".");
            MidnightControlsConfig.setButtonBinding(button, button.getButton());
        }
    }

    private static boolean checkValidity(@NotNull ButtonBinding binding, @NotNull String input, String group) {
        if (group == null) {
            MidnightControlsClient.get().warn("Malformed config value \"" + input + "\" for binding \"" + binding.getName() + "\".");
            MidnightControlsConfig.setButtonBinding(binding, binding.getButton());
            return false;
        }
        return true;
    }

    public static void setButtonBinding(@NotNull ButtonBinding binding, int[] button) {
        binding.setButton(button);
        MidnightControlsConfig.getBindingsForController().put("controller.controls." + binding.getName(), binding.getButtonCode());
        if (controllerBindingProfiles.containsKey(MidnightControlsConfig.getController().getGuid())) {
            controllerBindingProfiles.get(MidnightControlsConfig.getController().getGuid()).put("controller.controls." + binding.getName(), binding.getButtonCode());
        } else {
            BINDING.put("controller.controls." + binding.getName(), binding.getButtonCode());
        }
    }

    public static boolean isBackButton(int btn, boolean isBtn, int state) {
        if (!isBtn && state == 0) {
            return false;
        }
        return ButtonBinding.axisAsButton(1, false) == ButtonBinding.axisAsButton(btn, state == 1);
    }

    public static boolean isForwardButton(int btn, boolean isBtn, int state) {
        if (!isBtn && state == 0) {
            return false;
        }
        return ButtonBinding.axisAsButton(1, true) == ButtonBinding.axisAsButton(btn, state == 1);
    }

    public static boolean isLeftButton(int btn, boolean isBtn, int state) {
        if (!isBtn && state == 0) {
            return false;
        }
        return ButtonBinding.axisAsButton(0, false) == ButtonBinding.axisAsButton(btn, state == 1);
    }

    public static boolean isRightButton(int btn, boolean isBtn, int state) {
        if (!isBtn && state == 0) {
            return false;
        }
        return ButtonBinding.axisAsButton(0, true) == ButtonBinding.axisAsButton(btn, state == 1);
    }

    public static boolean isMovementAxis(int axis) {
        return axis == 1 || axis == 0;
    }

    public static void reset() {
        controlsMode = ControlsMode.DEFAULT;
        autoSwitchMode = true;
        debug = false;
        hudEnable = true;
        hudSide = HudSide.LEFT;
        analogMovement = true;
        doubleTapToSprint = true;
        controllerToggleSneak = (Boolean)class_310.method_1551().field_1690.method_42449().method_41753();
        controllerToggleSprint = (Boolean)class_310.method_1551().field_1690.method_42450().method_41753();
        fastBlockPlacing = false;
        flyDrifting = true;
        verticalFlyDrifting = true;
        horizontalReacharound = false;
        verticalReacharound = false;
        shouldRenderReacharoundOutline = true;
        reacharoundOutlineColorHex = "#ffffff";
        reacharoundOutlineColorAlpha = 102;
        rightDeadZone = 0.25;
        leftDeadZone = 0.25;
        invertRightYAxis = false;
        invertRightXAxis = false;
        yAxisRotationSpeed = rotationSpeed = 40.0;
        mouseSpeed = 25.0;
        unfocusedInput = false;
        virtualMouse = false;
        virtualMouseSkin = VirtualMouseSkin.DEFAULT_LIGHT;
        controllerID = 0;
        secondControllerID = -1;
        controllerType = ControllerType.DEFAULT;
        mouseScreens = Lists.newArrayList((Object[])new String[]{"net.minecraft.client.gui.screen.advancement", "net.minecraft.class_457", "net.minecraft.class_408", "net.minecraft.class_3872", "me.flashyreese.mods.reeses_sodium_options.client.gui", "dev.emi.emi.screen", "me.shedaniel.clothconfig2.gui.ClothConfigScreen", "com.mamiyaotaru.voxelmap.gui.GuiWaypoints", "com.mamiyaotaru.voxelmap.gui.GuiPersistentMap"});
        BINDING = new HashMap<String, String>();
        maxAnalogValueLeftX = 1.0;
        maxAnalogValueLeftY = 1.0;
        maxAnalogValueRightX = 1.0;
        maxAnalogValueRightY = 1.0;
        triggerFix = true;
        enableHints = true;
        shortcutInControls = true;
        ringBindings = new ArrayList<String>();
        ignoredUnboundKeys = Lists.newArrayList((Object[])new String[]{"inventorytabs.key.next_tab"});
        controllerBindingProfiles = new HashMap<String, Map<String, String>>();
    }

    @NotNull
    public static ControllerType matchControllerToType() {
        String controller = MidnightControlsConfig.getController().getName().toLowerCase();
        if (controller.contains("xbox 360")) {
            return ControllerType.XBOX_360;
        }
        if (controller.contains("xbox") || controller.contains("afterglow")) {
            return ControllerType.XBOX;
        }
        if (controller.contains("steam") && class_4494.method_22089().contains("AMD Custom APU")) {
            return ControllerType.STEAM_DECK;
        }
        if (controller.contains("steam")) {
            return ControllerType.STEAM_CONTROLLER;
        }
        if (controller.contains("dualsense") || controller.contains("ps5")) {
            return ControllerType.DUALSENSE;
        }
        if (controller.contains("dualshock") || controller.contains("ps4") || controller.contains("sony")) {
            return ControllerType.DUALSHOCK;
        }
        if (controller.contains("switch") || controller.contains("joy-con") || controller.contains("wii") || controller.contains("nintendo")) {
            return ControllerType.SWITCH;
        }
        if (controller.contains("ouya")) {
            return ControllerType.OUYA;
        }
        return ControllerType.DEFAULT;
    }

    static {
        yAxisRotationSpeed = rotationSpeed = 40.0;
        mouseSpeed = 25.0;
        joystickAsMouse = false;
        unfocusedInput = false;
        virtualMouse = false;
        virtualMouseSkin = VirtualMouseSkin.DEFAULT_LIGHT;
        hideNormalMouse = false;
        controllerID = 0;
        secondControllerID = -1;
        controllerType = ControllerType.DEFAULT;
        mouseScreens = Lists.newArrayList((Object[])new String[]{"net.minecraft.client.gui.screen.advancement", "net.minecraft.class_457", "net.minecraft.class_408", "net.minecraft.class_3872", "me.flashyreese.mods.reeses_sodium_options.client.gui", "dev.emi.emi.screen", "hardcorequesting.client.interfaces.GuiQuestBook", "hardcorequesting.client.interfaces.GuiReward", "hardcorequesting.client.interfaces.EditTrackerScreen", "me.shedaniel.clothconfig2.gui.ClothConfigScreen", "com.mamiyaotaru.voxelmap.gui.GuiWaypoints", "com.mamiyaotaru.voxelmap.gui.GuiPersistentMap"});
        arrowScreens = Lists.newArrayList((Object[])new String[]{class_408.class.getCanonicalName()});
        wasdScreens = Lists.newArrayList((Object[])new String[]{"com.ultreon.devices.core.Laptop"});
        BINDING = new HashMap<String, String>();
        BUTTON_BINDING_PATTERN = Pattern.compile("(-?\\d+)\\+?");
        maxAnalogValues = new double[]{1.0, 1.0, 1.0, 1.0};
        maxAnalogValueLeftX = maxAnalogValues[0];
        maxAnalogValueLeftY = maxAnalogValues[1];
        maxAnalogValueRightX = maxAnalogValues[2];
        maxAnalogValueRightY = maxAnalogValues[3];
        triggerFix = true;
        enableHints = true;
        shortcutInControls = true;
        ringBindings = new ArrayList<String>();
        ignoredUnboundKeys = Lists.newArrayList((Object[])new String[]{"inventorytabs.key.next_tab"});
        controllerBindingProfiles = new HashMap<String, Map<String, String>>();
        currentBindingProfile = new HashMap<String, String>();
    }
}

