/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.controller;

import eu.midnightdust.midnightcontrols.client.ButtonState;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.controller.ButtonCategory;
import eu.midnightdust.midnightcontrols.client.controller.InputHandlers;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.controller.MovementHandler;
import eu.midnightdust.midnightcontrols.client.controller.PressAction;
import eu.midnightdust.midnightcontrols.client.gui.RingScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_437;
import org.aperlambda.lambdacommon.utils.function.PairPredicate;
import org.aperlambda.lambdacommon.utils.function.Predicates;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButtonBinding {
    public static final ButtonCategory MOVEMENT_CATEGORY;
    public static final ButtonCategory GAMEPLAY_CATEGORY;
    public static final ButtonCategory INVENTORY_CATEGORY;
    public static final ButtonCategory MULTIPLAYER_CATEGORY;
    public static final ButtonCategory MISC_CATEGORY;
    public static final ButtonBinding ATTACK;
    public static final ButtonBinding BACK;
    public static final ButtonBinding CHAT;
    public static final ButtonBinding CONTROLS_RING;
    public static final ButtonBinding DROP_ITEM;
    public static final ButtonBinding FORWARD;
    public static final ButtonBinding HOTBAR_LEFT;
    public static final ButtonBinding HOTBAR_RIGHT;
    public static final ButtonBinding INVENTORY;
    public static final ButtonBinding EXIT;
    public static final ButtonBinding JUMP;
    public static final ButtonBinding LEFT;
    public static final ButtonBinding PAUSE_GAME;
    public static final ButtonBinding PICK_BLOCK;
    public static final ButtonBinding PLAYER_LIST;
    public static final ButtonBinding RIGHT;
    public static final ButtonBinding SCREENSHOT;
    public static final ButtonBinding DEBUG_SCREEN;
    public static final ButtonBinding SLOT_DOWN;
    public static final ButtonBinding SLOT_LEFT;
    public static final ButtonBinding SLOT_RIGHT;
    public static final ButtonBinding SLOT_UP;
    public static final ButtonBinding SNEAK;
    public static final ButtonBinding SPRINT;
    public static final ButtonBinding SWAP_HANDS;
    public static final ButtonBinding TAB_LEFT;
    public static final ButtonBinding TAB_RIGHT;
    public static final ButtonBinding PAGE_LEFT;
    public static final ButtonBinding PAGE_RIGHT;
    public static final ButtonBinding TAKE;
    public static final ButtonBinding TAKE_ALL;
    public static final ButtonBinding QUICK_MOVE;
    public static final ButtonBinding TOGGLE_PERSPECTIVE;
    public static final ButtonBinding USE;
    private int[] button;
    private final int[] defaultButton;
    private final String key;
    private final class_2561 text;
    private class_304 mcKeyBinding = null;
    protected PairPredicate<class_310, ButtonBinding> filter;
    private final List<PressAction> actions = new ArrayList<PressAction>(Collections.singletonList(PressAction.DEFAULT_ACTION));
    private boolean hasCooldown;
    private int cooldownLength = 5;
    private int cooldown = 0;
    boolean pressed = false;

    public ButtonBinding(String key, int[] defaultButton, List<PressAction> actions, PairPredicate<class_310, ButtonBinding> filter, boolean hasCooldown) {
        this.defaultButton = defaultButton;
        this.setButton(defaultButton);
        this.key = key;
        this.text = class_2561.method_43471((String)this.key);
        this.filter = filter;
        this.actions.addAll(actions);
        this.hasCooldown = hasCooldown;
    }

    public ButtonBinding(String key, int[] defaultButton, List<PressAction> actions, PairPredicate<class_310, ButtonBinding> filter, boolean hasCooldown, int cooldownLength) {
        this.defaultButton = defaultButton;
        this.setButton(defaultButton);
        this.key = key;
        this.text = class_2561.method_43471((String)this.key);
        this.filter = filter;
        this.actions.addAll(actions);
        this.hasCooldown = hasCooldown;
        this.cooldownLength = cooldownLength;
    }

    public ButtonBinding(String key, int[] defaultButton, boolean hasCooldown) {
        this(key, defaultButton, Collections.emptyList(), (PairPredicate<class_310, ButtonBinding>)Predicates.pairAlwaysTrue(), hasCooldown);
    }

    public ButtonBinding(String key, int[] defaultButton, boolean hasCooldown, int cooldownLength) {
        this(key, defaultButton, Collections.emptyList(), (PairPredicate<class_310, ButtonBinding>)Predicates.pairAlwaysTrue(), hasCooldown, cooldownLength);
    }

    public int[] getButton() {
        return this.button;
    }

    public void setButton(int[] button) {
        this.button = button;
        if (InputManager.hasBinding(this)) {
            InputManager.sortBindings();
        }
    }

    public boolean isButton(int[] button) {
        return InputManager.areButtonsEquivalent(button, this.button);
    }

    public boolean isButtonDown() {
        return this.pressed;
    }

    public boolean isNotBound() {
        return this.button.length == 0 || this.button[0] == -1;
    }

    public int[] getDefaultButton() {
        return this.defaultButton;
    }

    public boolean isDefault() {
        return this.button.length == this.defaultButton.length && InputManager.areButtonsEquivalent(this.button, this.defaultButton);
    }

    public String getButtonCode() {
        return Arrays.stream(this.button).mapToObj(btn -> Integer.valueOf(btn).toString()).collect(Collectors.joining("+"));
    }

    public void setKeyBinding(@Nullable class_304 keyBinding) {
        this.mcKeyBinding = keyBinding;
    }

    public boolean isAvailable(@NotNull class_310 client) {
        return this.filter.test((Object)client, (Object)this);
    }

    public void update() {
        if (this.hasCooldown && this.cooldown > 0) {
            --this.cooldown;
        }
    }

    public void handle(@NotNull class_310 client, float value, @NotNull ButtonState state) {
        if (state == ButtonState.REPEAT && this.hasCooldown && this.cooldown != 0) {
            return;
        }
        if (this.hasCooldown && state.isPressed()) {
            this.cooldown = this.cooldownLength;
        }
        for (int i = this.actions.size() - 1; i >= 0 && !this.actions.get(i).press(client, this, value, state); --i) {
        }
    }

    @NotNull
    public String getName() {
        return this.key;
    }

    @NotNull
    public String getTranslationKey() {
        return class_1074.method_4663((String)("midnightcontrols.action." + this.getName())) ? "midnightcontrols.action." + this.getName() : this.getName();
    }

    @NotNull
    public class_2561 getText() {
        return this.text;
    }

    @NotNull
    public Optional<class_304> asKeyBinding() {
        return Optional.ofNullable(this.mcKeyBinding);
    }

    public String toString() {
        return "ButtonBinding{id=\"" + this.key + "\",hasCooldown=" + this.hasCooldown + "}";
    }

    public static int axisAsButton(int axis, boolean positive) {
        return positive ? 100 + axis : 200 + axis;
    }

    public static boolean isAxis(int button) {
        return (button %= 500) >= 100;
    }

    public static int controller2Button(int button) {
        return 500 + button;
    }

    public static void init(@NotNull class_315 options) {
        ButtonBinding.ATTACK.mcKeyBinding = options.field_1886;
        ButtonBinding.BACK.mcKeyBinding = options.field_1881;
        ButtonBinding.CHAT.mcKeyBinding = options.field_1890;
        ButtonBinding.DROP_ITEM.mcKeyBinding = options.field_1869;
        ButtonBinding.FORWARD.mcKeyBinding = options.field_1894;
        ButtonBinding.INVENTORY.mcKeyBinding = options.field_1822;
        ButtonBinding.JUMP.mcKeyBinding = options.field_1903;
        ButtonBinding.LEFT.mcKeyBinding = options.field_1913;
        ButtonBinding.PICK_BLOCK.mcKeyBinding = options.field_1871;
        ButtonBinding.PLAYER_LIST.mcKeyBinding = options.field_1907;
        ButtonBinding.RIGHT.mcKeyBinding = options.field_1849;
        ButtonBinding.SCREENSHOT.mcKeyBinding = options.field_1835;
        ButtonBinding.SNEAK.mcKeyBinding = options.field_1832;
        ButtonBinding.SPRINT.mcKeyBinding = options.field_1867;
        ButtonBinding.SWAP_HANDS.mcKeyBinding = options.field_1831;
        ButtonBinding.TOGGLE_PERSPECTIVE.mcKeyBinding = options.field_1824;
        ButtonBinding.USE.mcKeyBinding = options.field_1904;
    }

    @NotNull
    public static class_2561 getLocalizedButtonName(int button) {
        return switch (button % 500) {
            case -1 -> class_2561.method_43471((String)"key.keyboard.unknown");
            case 0 -> class_2561.method_43471((String)"midnightcontrols.button.a");
            case 1 -> class_2561.method_43471((String)"midnightcontrols.button.b");
            case 2 -> class_2561.method_43471((String)"midnightcontrols.button.x");
            case 3 -> class_2561.method_43471((String)"midnightcontrols.button.y");
            case 4 -> class_2561.method_43471((String)"midnightcontrols.button.left_bumper");
            case 5 -> class_2561.method_43471((String)"midnightcontrols.button.right_bumper");
            case 6 -> class_2561.method_43471((String)"midnightcontrols.button.back");
            case 7 -> class_2561.method_43471((String)"midnightcontrols.button.start");
            case 8 -> class_2561.method_43471((String)"midnightcontrols.button.guide");
            case 9 -> class_2561.method_43471((String)"midnightcontrols.button.left_thumb");
            case 10 -> class_2561.method_43471((String)"midnightcontrols.button.right_thumb");
            case 11 -> class_2561.method_43471((String)"midnightcontrols.button.dpad_up");
            case 12 -> class_2561.method_43471((String)"midnightcontrols.button.dpad_right");
            case 13 -> class_2561.method_43471((String)"midnightcontrols.button.dpad_down");
            case 14 -> class_2561.method_43471((String)"midnightcontrols.button.dpad_left");
            case 100 -> class_2561.method_43471((String)"midnightcontrols.axis.left_x+");
            case 101 -> class_2561.method_43471((String)"midnightcontrols.axis.left_y+");
            case 102 -> class_2561.method_43471((String)"midnightcontrols.axis.right_x+");
            case 103 -> class_2561.method_43471((String)"midnightcontrols.axis.right_y+");
            case 104 -> class_2561.method_43471((String)"midnightcontrols.axis.left_trigger");
            case 105 -> class_2561.method_43471((String)"midnightcontrols.axis.right_trigger");
            case 200 -> class_2561.method_43471((String)"midnightcontrols.axis.left_x-");
            case 201 -> class_2561.method_43471((String)"midnightcontrols.axis.left_y-");
            case 202 -> class_2561.method_43471((String)"midnightcontrols.axis.right_x-");
            case 203 -> class_2561.method_43471((String)"midnightcontrols.axis.right_y-");
            case 15 -> class_2561.method_43471((String)"midnightcontrols.button.l4");
            case 16 -> class_2561.method_43471((String)"midnightcontrols.button.l5");
            case 17 -> class_2561.method_43471((String)"midnightcontrols.button.r4");
            case 18 -> class_2561.method_43471((String)"midnightcontrols.button.r5");
            default -> class_2561.method_43469((String)"midnightcontrols.button.unknown", (Object[])new Object[]{button});
        };
    }

    public static Builder builder(@NotNull class_2960 identifier) {
        return new Builder(identifier);
    }

    static {
        ATTACK = new Builder("attack").buttons(ButtonBinding.axisAsButton(5, true)).onlyInGame().register();
        BACK = new Builder("back").buttons(ButtonBinding.axisAsButton(1, false)).action(MovementHandler.HANDLER).onlyInGame().register();
        CHAT = new Builder("chat").buttons(12).onlyInGame().cooldown().register();
        CONTROLS_RING = new Builder("controls_ring").buttons(8).onlyInGame().cooldown().action((client, button1, value, action) -> {
            if (action.isPressed()) {
                MidnightControlsClient.get().ring.loadFromUnbound();
                client.method_1507((class_437)new RingScreen());
            }
            if (action.isUnpressed() && client.field_1755 != null) {
                client.field_1755.method_25419();
            }
            return true;
        }).register();
        DROP_ITEM = new Builder("drop_item").buttons(1).onlyInGame().cooldown().register();
        FORWARD = new Builder("forward").buttons(ButtonBinding.axisAsButton(1, true)).action(MovementHandler.HANDLER).onlyInGame().register();
        HOTBAR_LEFT = new Builder("hotbar_left").buttons(4).action(InputHandlers.handleHotbar(false)).onlyInGame().cooldown().register();
        HOTBAR_RIGHT = new Builder("hotbar_right").buttons(5).action(InputHandlers.handleHotbar(true)).onlyInGame().cooldown().register();
        INVENTORY = new Builder("inventory").buttons(3).onlyInGame().cooldown().register();
        EXIT = new Builder("exit").buttons(1).filter((PairPredicate<class_310, ButtonBinding>)((PairPredicate)(client, buttonBinding) -> client.field_1755 != null && buttonBinding.cooldown == 0 && ButtonBinding.INVENTORY.cooldown == 0)).action(InputHandlers.handleExit()).cooldown().register();
        JUMP = new Builder("jump").buttons(0).onlyInGame().register();
        LEFT = new Builder("left").buttons(ButtonBinding.axisAsButton(0, false)).action(MovementHandler.HANDLER).onlyInGame().register();
        PAUSE_GAME = new Builder("pause_game").buttons(7).action(InputHandlers::handlePauseGame).cooldown().register();
        PICK_BLOCK = new Builder("pick_block").buttons(14).onlyInGame().cooldown().register();
        PLAYER_LIST = new Builder("player_list").buttons(6).onlyInGame().register();
        RIGHT = new Builder("right").buttons(ButtonBinding.axisAsButton(0, true)).action(MovementHandler.HANDLER).onlyInGame().register();
        SCREENSHOT = new Builder("screenshot").buttons(11, 0).action(InputHandlers::handleScreenshot).cooldown().register();
        DEBUG_SCREEN = new Builder("debug_screen").buttons(11, 1).action((client, binding, value, action) -> {
            if (action == ButtonState.PRESS) {
                client.field_1690.field_1866 = !client.field_1690.field_1866;
            }
            return true;
        }).cooldown().register();
        SLOT_DOWN = new Builder("slot_down").buttons(13).action(InputHandlers.handleInventorySlotPad(1)).onlyInInventory().cooldown().register();
        SLOT_LEFT = new Builder("slot_left").buttons(14).action(InputHandlers.handleInventorySlotPad(3)).onlyInInventory().cooldown().register();
        SLOT_RIGHT = new Builder("slot_right").buttons(12).action(InputHandlers.handleInventorySlotPad(2)).onlyInInventory().cooldown().register();
        SLOT_UP = new Builder("slot_up").buttons(11).action(InputHandlers.handleInventorySlotPad(0)).onlyInInventory().cooldown().register();
        SNEAK = new Builder("sneak").buttons(10).actions(InputHandlers::handleToggleSneak).onlyInGame().cooldown().register();
        SPRINT = new Builder("sprint").buttons(9).actions(InputHandlers::handleToggleSprint).onlyInGame().register();
        SWAP_HANDS = new Builder("swap_hands").buttons(2).onlyInGame().cooldown().register();
        TAB_LEFT = new Builder("tab_back").buttons(4).action(InputHandlers.handleHotbar(false)).filter((PairPredicate<class_310, ButtonBinding>)Predicates.or(InputHandlers::inInventory, InputHandlers::inAdvancements).or((client, binding) -> client.field_1755 != null)).cooldown().register();
        TAB_RIGHT = new Builder("tab_next").buttons(5).action(InputHandlers.handleHotbar(true)).filter((PairPredicate<class_310, ButtonBinding>)Predicates.or(InputHandlers::inInventory, InputHandlers::inAdvancements).or((client, binding) -> client.field_1755 != null)).cooldown().register();
        PAGE_LEFT = new Builder("page_back").buttons(ButtonBinding.axisAsButton(4, true)).action(InputHandlers.handlePage(false)).filter((PairPredicate<class_310, ButtonBinding>)((PairPredicate)InputHandlers::inInventory)).cooldown(30).register();
        PAGE_RIGHT = new Builder("page_next").buttons(ButtonBinding.axisAsButton(5, true)).action(InputHandlers.handlePage(true)).filter((PairPredicate<class_310, ButtonBinding>)((PairPredicate)InputHandlers::inInventory)).cooldown(30).register();
        TAKE = new Builder("take").buttons(2).action(InputHandlers.handleActions()).filter((PairPredicate<class_310, ButtonBinding>)((PairPredicate)InputHandlers::inInventory)).cooldown().register();
        TAKE_ALL = new Builder("take_all").buttons(0).action(InputHandlers.handleActions()).filter((PairPredicate<class_310, ButtonBinding>)((PairPredicate)InputHandlers::inInventory)).cooldown().register();
        QUICK_MOVE = new Builder("quick_move").buttons(3).action(InputHandlers.handleActions()).filter((PairPredicate<class_310, ButtonBinding>)((PairPredicate)InputHandlers::inInventory)).cooldown().register();
        TOGGLE_PERSPECTIVE = new Builder("toggle_perspective").filter((PairPredicate<class_310, ButtonBinding>)((PairPredicate)InputHandlers::inGame)).buttons(11, 3).cooldown().register();
        USE = new Builder("use").buttons(ButtonBinding.axisAsButton(4, true)).register();
        MOVEMENT_CATEGORY = InputManager.registerDefaultCategory("key.categories.movement", category -> category.registerAllBindings(FORWARD, BACK, LEFT, RIGHT, JUMP, SNEAK, SPRINT));
        GAMEPLAY_CATEGORY = InputManager.registerDefaultCategory("key.categories.gameplay", category -> category.registerAllBindings(ATTACK, PICK_BLOCK, USE));
        INVENTORY_CATEGORY = InputManager.registerDefaultCategory("key.categories.inventory", category -> category.registerAllBindings(EXIT, DROP_ITEM, HOTBAR_LEFT, HOTBAR_RIGHT, INVENTORY, SWAP_HANDS, TAB_LEFT, TAB_RIGHT, PAGE_LEFT, PAGE_RIGHT, TAKE, TAKE_ALL, QUICK_MOVE, SLOT_UP, SLOT_DOWN, SLOT_LEFT, SLOT_RIGHT));
        MULTIPLAYER_CATEGORY = InputManager.registerDefaultCategory("key.categories.multiplayer", category -> category.registerAllBindings(CHAT, PLAYER_LIST));
        MISC_CATEGORY = InputManager.registerDefaultCategory("key.categories.misc", category -> category.registerAllBindings(SCREENSHOT, TOGGLE_PERSPECTIVE, PAUSE_GAME, DEBUG_SCREEN, CONTROLS_RING));
    }

    public static class Builder {
        private final String key;
        private int[] buttons = new int[0];
        private final List<PressAction> actions = new ArrayList<PressAction>();
        private PairPredicate<class_310, ButtonBinding> filter = Predicates.pairAlwaysTrue();
        private boolean cooldown = false;
        private int cooldownLength = 5;
        private ButtonCategory category = null;
        private class_304 mcBinding = null;

        public Builder(@NotNull String key) {
            this.key = key;
            this.unbound();
        }

        public Builder(@NotNull class_2960 identifier) {
            this(identifier.method_12836() + "." + identifier.method_12832());
        }

        public Builder buttons(int ... buttons) {
            this.buttons = buttons;
            return this;
        }

        public Builder unbound() {
            return this.buttons(-1);
        }

        public Builder actions(PressAction ... actions) {
            this.actions.addAll(Arrays.asList(actions));
            return this;
        }

        public Builder action(@NotNull PressAction action) {
            this.actions.add(action);
            return this;
        }

        public Builder filter(@NotNull PairPredicate<class_310, ButtonBinding> filter) {
            this.filter = filter;
            return this;
        }

        public Builder onlyInGame() {
            return this.filter((PairPredicate<class_310, ButtonBinding>)((PairPredicate)InputHandlers::inGame));
        }

        public Builder onlyInInventory() {
            return this.filter((PairPredicate<class_310, ButtonBinding>)((PairPredicate)InputHandlers::inInventory));
        }

        public Builder cooldown(boolean cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder cooldown(int cooldownLength) {
            this.cooldownLength = cooldownLength;
            this.cooldown = true;
            return this;
        }

        public Builder cooldown() {
            return this.cooldown(true);
        }

        public Builder category(@Nullable ButtonCategory category) {
            this.category = category;
            return this;
        }

        public Builder linkKeybind(@Nullable class_304 binding) {
            this.mcBinding = binding;
            return this;
        }

        public ButtonBinding build() {
            ButtonBinding binding = new ButtonBinding(this.key, this.buttons, this.actions, this.filter, this.cooldown, this.cooldownLength);
            if (this.category != null) {
                this.category.registerBinding(binding);
            }
            if (this.mcBinding != null) {
                binding.setKeyBinding(this.mcBinding);
            }
            return binding;
        }

        public ButtonBinding register() {
            return InputManager.registerBinding(this.build());
        }
    }
}

