/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.MiscUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import org.apache.commons.lang3.tuple.Pair;

public class OverlayRendererSpawnChunks
extends OverlayRendererBase {
    protected static boolean needsUpdate = true;
    protected final RendererToggle toggle;
    protected final boolean isPlayerFollowing;

    public static void setNeedsUpdate() {
        needsUpdate = true;
    }

    public OverlayRendererSpawnChunks(RendererToggle toggle) {
        this.toggle = toggle;
        this.isPlayerFollowing = toggle == RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER;
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return this.toggle.getBooleanValue() && (this.isPlayerFollowing || mc.field_1687 != null && MiscUtils.isOverworld((class_1937)mc.field_1687) && DataStorage.getInstance().isWorldSpawnKnown());
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        if (needsUpdate) {
            return true;
        }
        entity = this.isPlayerFollowing ? mc.field_1724 : entity;
        int ex = (int)Math.floor(entity.method_23317());
        int ez = (int)Math.floor(entity.method_23321());
        int lx = this.lastUpdatePos.method_10263();
        int lz = this.lastUpdatePos.method_10260();
        if (this.isPlayerFollowing) {
            return ex != lx || ez != lz;
        }
        int range = (Integer)mc.field_1690.method_42503().method_41753() * 16;
        return Math.abs(lx - ex) > range || Math.abs(lz - ez) > range;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc) {
        entity = this.isPlayerFollowing ? mc.field_1724 : entity;
        DataStorage data = DataStorage.getInstance();
        class_2338 spawn = this.isPlayerFollowing ? PositionUtils.getEntityBlockPos((class_1297)entity) : data.getWorldSpawn();
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.method_1328(renderQuads.getGlMode(), class_290.field_1576);
        BUFFER_2.method_1328(renderLines.getGlMode(), class_290.field_1576);
        Color4f colorEntity = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_ENTITY_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_ENTITY_OVERLAY_COLOR.getColor();
        Color4f colorLazy = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_LAZY_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_LAZY_OVERLAY_COLOR.getColor();
        Color4f colorOuter = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_OUTER_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_OUTER_OVERLAY_COLOR.getColor();
        fi.dy.masa.malilib.render.RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((class_2338)spawn, (class_243)cameraPos, (Color4f)colorEntity, (double)0.001, (class_287)BUFFER_2);
        OverlayRendererSpawnChunks.drawBlockBoundingBoxSidesBatchedQuads(spawn, cameraPos, colorEntity, 0.001, BUFFER_1);
        Pair<class_2338, class_2338> corners = this.getSpawnChunkCorners(spawn, 22, (class_1937)mc.field_1687);
        RenderUtils.renderWallsWithLines((class_2338)corners.getLeft(), (class_2338)corners.getRight(), cameraPos, 16.0, 16.0, true, colorOuter, BUFFER_1, BUFFER_2);
        corners = this.getSpawnChunkCorners(spawn, 11, (class_1937)mc.field_1687);
        RenderUtils.renderWallsWithLines((class_2338)corners.getLeft(), (class_2338)corners.getRight(), cameraPos, 16.0, 16.0, true, colorLazy, BUFFER_1, BUFFER_2);
        corners = this.getSpawnChunkCorners(spawn, 9, (class_1937)mc.field_1687);
        RenderUtils.renderWallsWithLines((class_2338)corners.getLeft(), (class_2338)corners.getRight(), cameraPos, 16.0, 16.0, true, colorEntity, BUFFER_1, BUFFER_2);
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
        needsUpdate = false;
    }

    protected Pair<class_2338, class_2338> getSpawnChunkCorners(class_2338 worldSpawn, int chunkRange, class_1937 world) {
        int cx = worldSpawn.method_10263() >> 4;
        int cz = worldSpawn.method_10260() >> 4;
        int minY = world != null ? world.method_31607() : -64;
        int maxY = world != null ? world.method_31600() : 320;
        class_2338 pos1 = new class_2338(cx - chunkRange << 4, minY, cz - chunkRange << 4);
        class_2338 pos2 = new class_2338((cx + chunkRange << 4) + 15, maxY, (cz + chunkRange << 4) + 15);
        return Pair.of((Object)pos1, (Object)pos2);
    }

    public static void drawBlockBoundingBoxSidesBatchedQuads(class_2338 pos, class_243 cameraPos, Color4f color, double expand, class_287 buffer) {
        double minX = (double)pos.method_10263() - cameraPos.field_1352 - expand;
        double minY = (double)pos.method_10264() - cameraPos.field_1351 - expand;
        double minZ = (double)pos.method_10260() - cameraPos.field_1350 - expand;
        double maxX = (double)pos.method_10263() - cameraPos.field_1352 + expand + 1.0;
        double maxY = (double)pos.method_10264() - cameraPos.field_1351 + expand + 1.0;
        double maxZ = (double)pos.method_10260() - cameraPos.field_1350 + expand + 1.0;
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllSidesBatchedQuads((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)color, (class_287)buffer);
    }
}

