/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.util.BlockSnap;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.renderer.shapes.ShapeBlocky;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;

public abstract class ShapeCircleBase
extends ShapeBlocky {
    protected class_2350 mainAxis = class_2350.field_11036;
    private final double maxRadius = 1024.0;
    private double radius;
    private double radiusSq;
    private class_243 center = class_243.field_1353;
    private class_243 effectiveCenter = class_243.field_1353;

    public ShapeCircleBase(ShapeType type, Color4f color, double radius) {
        super(type, color);
        this.setRadius(radius);
        class_1297 entity = EntityUtils.getCameraEntity();
        if (entity != null) {
            class_243 center = entity.method_19538();
            center = new class_243(Math.floor(center.field_1352) + 0.5, Math.floor(center.field_1351), Math.floor(center.field_1350) + 0.5);
            this.setCenter(center);
        } else {
            this.setCenter(class_243.field_1353);
        }
    }

    public class_243 getCenter() {
        return this.center;
    }

    public class_243 getEffectiveCenter() {
        return this.effectiveCenter;
    }

    public void setCenter(class_243 center) {
        this.center = center;
        this.updateEffectiveCenter();
    }

    public double getRadius() {
        return this.radius;
    }

    public double getSquaredRadius() {
        return this.radiusSq;
    }

    public void setRadius(double radius) {
        if (radius >= 0.0 && radius <= this.maxRadius) {
            this.radius = radius;
            this.radiusSq = radius * radius;
            this.setRenderPerimeter(this.effectiveCenter, this.radius + 512.0);
            this.setNeedsUpdate();
        }
    }

    public class_2350 getMainAxis() {
        return this.mainAxis;
    }

    public void setMainAxis(class_2350 mainAxis) {
        this.mainAxis = mainAxis;
        this.setNeedsUpdate();
    }

    protected class_2338 getCenterBlock() {
        return class_2338.method_49638((class_2374)this.effectiveCenter);
    }

    @Override
    public void setBlockSnap(BlockSnap snap) {
        super.setBlockSnap(snap);
        this.updateEffectiveCenter();
    }

    protected void updateEffectiveCenter() {
        this.effectiveCenter = this.getBlockSnappedPosition(this.center);
        this.setRenderPerimeter(this.effectiveCenter, this.radius + 512.0);
        this.setNeedsUpdate();
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("center", (JsonElement)JsonUtils.vec3dToJson((class_243)this.center));
        obj.add("main_axis", (JsonElement)new JsonPrimitive(this.mainAxis.name()));
        obj.add("radius", (JsonElement)new JsonPrimitive((Number)this.getRadius()));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        class_243 center;
        class_2350 facing;
        super.fromJson(obj);
        if (JsonUtils.hasString((JsonObject)obj, (String)"main_axis") && (facing = class_2350.valueOf((String)obj.get("main_axis").getAsString())) != null) {
            this.setMainAxis(facing);
        }
        if (JsonUtils.hasDouble((JsonObject)obj, (String)"radius")) {
            this.setRadius(JsonUtils.getDouble((JsonObject)obj, (String)"radius"));
        }
        if ((center = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"center")) != null) {
            this.setCenter(center);
        }
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        BlockSnap snap = this.getBlockSnap();
        class_243 c = this.center;
        lines.add(StringUtils.translate((String)"minihud.gui.hover.shape.radius_value", (Object[])new Object[]{this.getRadius()}));
        lines.add(StringUtils.translate((String)"minihud.gui.hover.shape.center_value", (Object[])new Object[]{ShapeCircleBase.d2(c.field_1352), ShapeCircleBase.d2(c.field_1351), ShapeCircleBase.d2(c.field_1350)}));
        if (snap != BlockSnap.NONE) {
            c = this.effectiveCenter;
            lines.add(StringUtils.translate((String)"minihud.gui.hover.shape.effective_center_value", (Object[])new Object[]{ShapeCircleBase.d2(c.field_1352), ShapeCircleBase.d2(c.field_1351), ShapeCircleBase.d2(c.field_1350)}));
        }
        return lines;
    }
}

