/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_handlers;

import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1011;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3879;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.screens.ETFConfigScreen;
import traben.entity_texture_features.entity_handlers.ETFEntity;
import traben.entity_texture_features.texture_handlers.ETFDirectory;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFTexture {
    private static final String PATCH_NAMESPACE_PREFIX = "etf_patched_";
    private static final Random randomBlink = new Random();
    public final class_2960 thisIdentifier;
    private final Object2ReferenceOpenHashMap<class_2960, class_2960> FEATURE_TEXTURE_MAP = new Object2ReferenceOpenHashMap();
    private final int variantNumber;
    public TextureReturnState currentTextureState = TextureReturnState.NORMAL;
    private class_2960 thisIdentifier_Patched = null;
    private class_2960 emissiveIdentifier = null;
    private class_2960 emissiveBlinkIdentifier = null;
    private class_2960 emissiveBlink2Identifier = null;
    private class_2960 blinkIdentifier = null;
    private class_2960 blink2Identifier = null;
    private class_2960 blinkIdentifier_Patched = null;
    private class_2960 blink2Identifier_Patched = null;
    private Integer blinkLength;
    private Integer blinkFrequency;
    private boolean canPatch;

    public ETFTexture(class_2960 variantIdentifier, boolean allowedToPatch) {
        this.blinkLength = ETFClientCommon.ETFConfigData.blinkLength;
        this.blinkFrequency = ETFClientCommon.ETFConfigData.blinkFrequency;
        this.canPatch = true;
        if (variantIdentifier == null) {
            ETFUtils2.logError("ETFTexture had a null identifier this MUST never happen");
            this.thisIdentifier = null;
            this.variantNumber = 0;
            return;
        }
        this.thisIdentifier = variantIdentifier;
        Pattern pattern = Pattern.compile("\\d+(?=\\.png)");
        Matcher matcher = pattern.matcher(variantIdentifier.method_12832());
        int intFound = 0;
        try {
            if (matcher.find()) {
                intFound = Integer.parseInt(matcher.group());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.variantNumber = intFound;
        this.canPatch = allowedToPatch;
        this.setupBlinking();
        this.setupEmissives();
    }

    public ETFTexture(@NotNull class_2960 modifiedSkinIdentifier, @Nullable class_2960 blinkIdentifier, @Nullable class_2960 blink2Identifier, @Nullable class_2960 emissiveIdentifier, @Nullable class_2960 blinkEmissiveIdentifier, @Nullable class_2960 blink2EmissiveIdentifier, @Nullable class_2960 modifiedSkinPatchedIdentifier, @Nullable class_2960 modifiedSkinBlinkPatchedIdentifier, @Nullable class_2960 modifiedSkinBlink2PatchedIdentifier) {
        this.blinkLength = ETFClientCommon.ETFConfigData.blinkLength;
        this.blinkFrequency = ETFClientCommon.ETFConfigData.blinkFrequency;
        this.canPatch = true;
        this.variantNumber = 0;
        this.thisIdentifier = modifiedSkinIdentifier;
        this.blinkIdentifier = blinkIdentifier;
        this.blink2Identifier = blink2Identifier;
        this.emissiveIdentifier = emissiveIdentifier;
        this.emissiveBlinkIdentifier = blinkEmissiveIdentifier;
        this.emissiveBlink2Identifier = blink2EmissiveIdentifier;
        this.thisIdentifier_Patched = modifiedSkinPatchedIdentifier;
        this.blinkIdentifier_Patched = modifiedSkinBlinkPatchedIdentifier;
        this.blink2Identifier_Patched = modifiedSkinBlink2PatchedIdentifier;
    }

    public ETFTexture(@NotNull class_2960 modifiedSkinIdentifier, @Nullable class_2960 emissiveIdentifier) {
        this.blinkLength = ETFClientCommon.ETFConfigData.blinkLength;
        this.blinkFrequency = ETFClientCommon.ETFConfigData.blinkFrequency;
        this.canPatch = true;
        this.variantNumber = 0;
        this.thisIdentifier = modifiedSkinIdentifier;
        this.emissiveIdentifier = emissiveIdentifier;
    }

    public static void patchTextureToRemoveZFightingWithOtherTexture(class_1011 baseImage, class_1011 otherImage) throws IndexOutOfBoundsException {
        try {
            if (otherImage.method_4307() == baseImage.method_4307() && otherImage.method_4323() == baseImage.method_4323()) {
                for (int x = 0; x < baseImage.method_4307(); ++x) {
                    for (int y = 0; y < baseImage.method_4323(); ++y) {
                        if (otherImage.method_4311(x, y) == 0) continue;
                        baseImage.method_4305(x, y, 0);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IndexOutOfBoundsException("additional texture is not the correct size, ETF has crashed in the patching stage");
        }
    }

    private void setupBlinking() {
        String blink1PackName;
        class_2960 possibleBlinkIdentifier;
        Optional blinkR1;
        class_3300 resourceManager;
        Optional vanillaR1;
        if (ETFClientCommon.ETFConfigData.enableBlinking && (vanillaR1 = (resourceManager = class_310.method_1551().method_1478()).method_14486(this.thisIdentifier)).isPresent() && (blinkR1 = resourceManager.method_14486(possibleBlinkIdentifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink.png"))).isPresent() && (blink1PackName = ((class_3298)blinkR1.get()).method_14480()).equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(new String[]{blink1PackName, ((class_3298)vanillaR1.get()).method_14480()}))) {
            String propertyResourcePackName;
            Optional propertyResource;
            class_2960 propertyIdentifier;
            Properties blinkingProps;
            String blink2PackName;
            this.blinkIdentifier = possibleBlinkIdentifier;
            class_2960 possibleBlink2Identifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink2.png");
            Optional blinkR2 = resourceManager.method_14486(possibleBlink2Identifier);
            if (blinkR2.isPresent() && blink1PackName.equals(blink2PackName = ((class_3298)blinkR2.get()).method_14480())) {
                this.blink2Identifier = possibleBlink2Identifier;
            }
            if ((blinkingProps = ETFUtils2.readAndReturnPropertiesElseNull(propertyIdentifier = ETFUtils2.replaceIdentifier(possibleBlinkIdentifier, ".png", ".properties"))) != null && (propertyResource = resourceManager.method_14486(propertyIdentifier)).isPresent() && (propertyResourcePackName = ((class_3298)propertyResource.get()).method_14480()).equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(new String[]{propertyResourcePackName, blink1PackName}))) {
                this.blinkLength = blinkingProps.containsKey("blinkLength") ? Integer.parseInt(blinkingProps.getProperty("blinkLength").replaceAll("\\D", "")) : ETFClientCommon.ETFConfigData.blinkLength;
                this.blinkFrequency = blinkingProps.containsKey("blinkFrequency") ? Integer.parseInt(blinkingProps.getProperty("blinkFrequency").replaceAll("\\D", "")) : ETFClientCommon.ETFConfigData.blinkFrequency;
            }
        }
    }

    private void setupEmissives() {
        if (ETFClientCommon.ETFConfigData.enableEmissiveTextures) {
            class_3300 resourceManager = class_310.method_1551().method_1478();
            for (String possibleEmissiveSuffix : ETFManager.getInstance().EMISSIVE_SUFFIX_LIST) {
                String emissiveBlink2PackName;
                String emissiveBlinkPackName;
                String emissivePackName;
                class_2960 possibleEmissiveIdentifier;
                Optional emissiveR1;
                Optional vanillaR1 = resourceManager.method_14486(this.thisIdentifier);
                if (!vanillaR1.isPresent() || !(emissiveR1 = resourceManager.method_14486(possibleEmissiveIdentifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", possibleEmissiveSuffix + ".png"))).isPresent() || !(emissivePackName = ((class_3298)emissiveR1.get()).method_14480()).equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(new String[]{emissivePackName, ((class_3298)vanillaR1.get()).method_14480()}))) continue;
                this.emissiveIdentifier = possibleEmissiveIdentifier;
                class_2960 possibleEmissiveBlinkIdentifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink" + possibleEmissiveSuffix + ".png");
                Optional emissiveBlinkR1 = resourceManager.method_14486(possibleEmissiveBlinkIdentifier);
                if (!emissiveBlinkR1.isPresent() || !(emissiveBlinkPackName = ((class_3298)emissiveBlinkR1.get()).method_14480()).equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(new String[]{emissiveBlinkPackName, ((class_3298)vanillaR1.get()).method_14480()}))) break;
                this.emissiveBlinkIdentifier = possibleEmissiveBlinkIdentifier;
                class_2960 possibleEmissiveBlink2Identifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink2" + possibleEmissiveSuffix + ".png");
                Optional emissiveBlink2R1 = resourceManager.method_14486(possibleEmissiveBlink2Identifier);
                if (!emissiveBlink2R1.isPresent() || !(emissiveBlink2PackName = ((class_3298)emissiveBlink2R1.get()).method_14480()).equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(new String[]{emissiveBlink2PackName, ((class_3298)vanillaR1.get()).method_14480()}))) break;
                this.emissiveBlink2Identifier = possibleEmissiveBlink2Identifier;
                break;
            }
            if (this.isEmissive()) {
                this.createPatchedTextures();
            }
        }
    }

    private void createPatchedTextures() {
        if (this.canPatch) {
            return;
        }
        class_1011 newBaseTexture = ETFUtils2.getNativeImageElseNull(this.thisIdentifier);
        class_1011 newBlinkTexture = ETFUtils2.getNativeImageElseNull(this.blinkIdentifier);
        class_1011 newBlink2Texture = ETFUtils2.getNativeImageElseNull(this.blink2Identifier);
        boolean didPatch = false;
        class_3300 files = class_310.method_1551().method_1478();
        if (ETFClientCommon.ETFConfigData.dontPatchPBRTextures && (ETFVersionDifferenceHandler.isThisModLoaded("iris") || ETFVersionDifferenceHandler.isThisModLoaded("oculus")) && (files.method_14486(ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_s.png")).isPresent() || files.method_14486(ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_n.png")).isPresent())) {
            return;
        }
        if (ETFClientCommon.ETFConfigData.dontPatchAnimatedTextures && ETFVersionDifferenceHandler.isThisModLoaded("moremcmeta") && (files.method_14486(ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", ".png.mcmeta")).isPresent() || files.method_14486(ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", ".png.moremcmeta")).isPresent())) {
            return;
        }
        if (this.emissiveIdentifier != null && ETFClientCommon.ETFConfigData.enableEmissiveTextures) {
            class_1011 emissiveImage = ETFUtils2.getNativeImageElseNull(this.emissiveIdentifier);
            try {
                ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(newBaseTexture, emissiveImage);
                didPatch = true;
                if (this.doesBlink() && this.emissiveBlinkIdentifier != null) {
                    class_1011 emissiveBlinkImage = ETFUtils2.getNativeImageElseNull(this.emissiveBlinkIdentifier);
                    ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(newBlinkTexture, emissiveBlinkImage);
                    if (this.doesBlink2() && this.emissiveBlink2Identifier != null) {
                        class_1011 emissiveBlink2Image = ETFUtils2.getNativeImageElseNull(this.emissiveBlink2Identifier);
                        ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(newBlink2Texture, emissiveBlink2Image);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (didPatch) {
                this.thisIdentifier_Patched = new class_2960(PATCH_NAMESPACE_PREFIX + this.thisIdentifier.method_12836(), this.thisIdentifier.method_12832());
                ETFUtils2.registerNativeImageToIdentifier(newBaseTexture, this.thisIdentifier_Patched);
                if (this.doesBlink()) {
                    this.blinkIdentifier_Patched = new class_2960(PATCH_NAMESPACE_PREFIX + this.blinkIdentifier.method_12836(), this.blinkIdentifier.method_12832());
                    ETFUtils2.registerNativeImageToIdentifier(newBlinkTexture, this.blinkIdentifier_Patched);
                    if (this.doesBlink2()) {
                        this.blink2Identifier_Patched = new class_2960(PATCH_NAMESPACE_PREFIX + this.blink2Identifier.method_12836(), this.blink2Identifier.method_12832());
                        ETFUtils2.registerNativeImageToIdentifier(newBlink2Texture, this.blink2Identifier_Patched);
                    }
                }
            }
        }
    }

    @NotNull
    class_2960 getFeatureTexture(class_2960 vanillaFeatureTexture) {
        ETFDirectory tryDirectory;
        if (this.FEATURE_TEXTURE_MAP.containsKey((Object)vanillaFeatureTexture)) {
            return (class_2960)this.FEATURE_TEXTURE_MAP.get((Object)vanillaFeatureTexture);
        }
        ETFDirectory directory = ETFDirectory.getDirectoryOf(this.thisIdentifier);
        if (this.variantNumber != 0) {
            class_2960 possibleFeatureVariantIdentifier = ETFDirectory.getIdentifierAsDirectory(ETFUtils2.replaceIdentifier(vanillaFeatureTexture, ".png", this.variantNumber + ".png"), directory);
            Optional possibleResource = class_310.method_1551().method_1478().method_14486(possibleFeatureVariantIdentifier);
            if (possibleResource.isPresent()) {
                this.FEATURE_TEXTURE_MAP.put((Object)vanillaFeatureTexture, (Object)possibleFeatureVariantIdentifier);
                return possibleFeatureVariantIdentifier;
            }
        }
        if ((tryDirectory = ETFDirectory.getDirectoryOf(vanillaFeatureTexture)) == directory || tryDirectory == ETFDirectory.VANILLA) {
            class_2960 tryDirectoryVariant = ETFDirectory.getIdentifierAsDirectory(vanillaFeatureTexture, tryDirectory);
            this.FEATURE_TEXTURE_MAP.put((Object)vanillaFeatureTexture, (Object)tryDirectoryVariant);
            return tryDirectoryVariant;
        }
        this.FEATURE_TEXTURE_MAP.put((Object)vanillaFeatureTexture, (Object)vanillaFeatureTexture);
        return vanillaFeatureTexture;
    }

    @NotNull
    public class_2960 getTextureIdentifier(ETFEntity entity) {
        return this.getTextureIdentifier(entity, false);
    }

    @NotNull
    public class_2960 getTextureIdentifier(@Nullable ETFEntity entity, boolean forcePatchedTexture) {
        if (this.isPatched() && (forcePatchedTexture || ETFClientCommon.ETFConfigData.enableEmissiveTextures && ETFVersionDifferenceHandler.areShadersInUse() || class_310.method_1551().field_1755 instanceof ETFConfigScreen)) {
            this.currentTextureState = TextureReturnState.NORMAL_PATCHED;
            return this.getBlinkingIdentifier(entity);
        }
        this.currentTextureState = TextureReturnState.NORMAL;
        return this.getBlinkingIdentifier(entity);
    }

    @NotNull
    private class_2960 getBlinkingIdentifier(@Nullable ETFEntity entity) {
        class_1309 alive;
        if (!this.doesBlink() || entity == null || !ETFClientCommon.ETFConfigData.enableBlinking) {
            return this.identifierOfCurrentState();
        }
        if (entity.getPose() == class_4050.field_18078) {
            this.modifyTextureState(TextureReturnState.APPLY_BLINK);
            return this.identifierOfCurrentState();
        }
        class_1297 class_12972 = entity.entity();
        if (class_12972 instanceof class_1309 && (alive = (class_1309)class_12972).method_6059(class_1294.field_5919)) {
            this.modifyTextureState(this.doesBlink2() ? TextureReturnState.APPLY_BLINK2 : TextureReturnState.APPLY_BLINK);
            return this.identifierOfCurrentState();
        }
        if (entity.getWorld() != null) {
            UUID id = entity.getUuid();
            if (!ETFManager.getInstance().ENTITY_BLINK_TIME.containsKey((Object)id)) {
                ETFManager.getInstance().ENTITY_BLINK_TIME.put((Object)id, entity.getWorld().method_8510() + (long)this.blinkLength.intValue() + 1L);
                return this.identifierOfCurrentState();
            }
            long nextBlink = ETFManager.getInstance().ENTITY_BLINK_TIME.getLong((Object)id);
            long currentTime = entity.getWorld().method_8510();
            if (currentTime >= nextBlink - (long)this.blinkLength.intValue() && currentTime <= nextBlink + (long)this.blinkLength.intValue()) {
                if (this.doesBlink2()) {
                    if (currentTime >= nextBlink - (long)(this.blinkLength / 3) && currentTime <= nextBlink + (long)(this.blinkLength / 3)) {
                        this.modifyTextureState(TextureReturnState.APPLY_BLINK);
                        return this.identifierOfCurrentState();
                    }
                    this.modifyTextureState(TextureReturnState.APPLY_BLINK2);
                    return this.identifierOfCurrentState();
                }
                if (currentTime <= nextBlink) {
                    this.modifyTextureState(TextureReturnState.APPLY_BLINK);
                    return this.identifierOfCurrentState();
                }
            } else if (currentTime > nextBlink + (long)this.blinkLength.intValue()) {
                ETFManager.getInstance().ENTITY_BLINK_TIME.put((Object)id, currentTime + (long)randomBlink.nextInt(this.blinkFrequency) + 20L);
            }
        }
        return this.identifierOfCurrentState();
    }

    public boolean isEmissive() {
        return this.emissiveIdentifier != null;
    }

    public boolean isPatched() {
        return this.thisIdentifier_Patched != null;
    }

    public boolean doesBlink() {
        return this.blinkIdentifier != null;
    }

    public boolean doesBlink2() {
        return this.blink2Identifier != null;
    }

    public String toString() {
        return "ETFTexture{texture=" + this.thisIdentifier.toString() + ", emissive=" + this.isEmissive() + ", patched=" + this.isPatched() + "}";
    }

    public void renderEmissive(class_4587 matrixStack, class_4597 vertexConsumerProvider, class_630 modelPart) {
        this.renderEmissive(matrixStack, vertexConsumerProvider, modelPart, ETFManager.getEmissiveMode());
    }

    public void renderEmissive(class_4587 matrixStack, class_4597 vertexConsumerProvider, class_630 modelPart, ETFManager.EmissiveRenderModes modeToUsePossiblyManuallyChosen) {
        class_4588 vertexC = this.getEmissiveVertexConsumer(vertexConsumerProvider, null, modeToUsePossiblyManuallyChosen);
        if (vertexC != null) {
            modelPart.method_22698(matrixStack, vertexC, 0xF000F0, class_4608.field_21444);
        }
    }

    public void renderEmissive(class_4587 matrixStack, class_4597 vertexConsumerProvider, class_3879 model) {
        this.renderEmissive(matrixStack, vertexConsumerProvider, model, ETFManager.getEmissiveMode());
    }

    public void renderEmissive(class_4587 matrixStack, class_4597 vertexConsumerProvider, class_3879 model, ETFManager.EmissiveRenderModes modeToUsePossiblyManuallyChosen) {
        class_4588 vertexC = this.getEmissiveVertexConsumer(vertexConsumerProvider, model, modeToUsePossiblyManuallyChosen);
        if (vertexC != null) {
            model.method_2828(matrixStack, vertexC, 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Nullable
    public class_4588 getEmissiveVertexConsumer(class_4597 vertexConsumerProvider, @Nullable class_3879 model, ETFManager.EmissiveRenderModes modeToUsePossiblyManuallyChosen) {
        class_2960 emissiveToUse;
        if (this.isEmissive() && (emissiveToUse = this.getEmissiveIdentifierOfCurrentState()) != null) {
            if (modeToUsePossiblyManuallyChosen == ETFManager.EmissiveRenderModes.BRIGHT) {
                return vertexConsumerProvider.getBuffer(class_1921.method_23592((class_2960)emissiveToUse, (!ETFVersionDifferenceHandler.areShadersInUse() ? 1 : 0) != 0));
            }
            if (model == null) {
                return vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)emissiveToUse));
            }
            return vertexConsumerProvider.getBuffer(model.method_23500(emissiveToUse));
        }
        return null;
    }

    private void modifyTextureState(TextureReturnState givenState) {
        switch (givenState) {
            case APPLY_BLINK: {
                this.currentTextureState = this.currentTextureState == TextureReturnState.NORMAL_PATCHED ? TextureReturnState.BLINK_PATCHED : TextureReturnState.BLINK;
                break;
            }
            case APPLY_BLINK2: {
                this.currentTextureState = switch (this.currentTextureState) {
                    case TextureReturnState.NORMAL_PATCHED, TextureReturnState.BLINK_PATCHED -> TextureReturnState.BLINK2_PATCHED;
                    default -> TextureReturnState.BLINK2;
                };
            }
        }
    }

    @NotNull
    private class_2960 identifierOfCurrentState() {
        return switch (this.currentTextureState) {
            case TextureReturnState.NORMAL -> this.thisIdentifier;
            case TextureReturnState.NORMAL_PATCHED -> this.thisIdentifier_Patched;
            case TextureReturnState.BLINK -> this.blinkIdentifier;
            case TextureReturnState.BLINK_PATCHED -> this.blinkIdentifier_Patched;
            case TextureReturnState.BLINK2 -> this.blink2Identifier;
            case TextureReturnState.BLINK2_PATCHED -> this.blink2Identifier_Patched;
            default -> this.thisIdentifier;
        };
    }

    @Nullable
    public class_2960 getEmissiveIdentifierOfCurrentState() {
        return switch (this.currentTextureState) {
            case TextureReturnState.NORMAL_PATCHED, TextureReturnState.NORMAL -> this.emissiveIdentifier;
            case TextureReturnState.BLINK_PATCHED, TextureReturnState.BLINK -> this.emissiveBlinkIdentifier;
            case TextureReturnState.BLINK2, TextureReturnState.BLINK2_PATCHED -> this.emissiveBlink2Identifier;
            default -> null;
        };
    }

    public static enum TextureReturnState {
        NORMAL,
        NORMAL_PATCHED,
        BLINK,
        BLINK_PATCHED,
        BLINK2,
        BLINK2_PATCHED,
        APPLY_PATCH,
        APPLY_BLINK,
        APPLY_BLINK2;


        public String toString() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NORMAL -> "normal";
                case BLINK -> "blink";
                case BLINK2 -> "blink2";
                case NORMAL_PATCHED -> "normal_patched";
                case BLINK_PATCHED -> "blink_patched";
                case BLINK2_PATCHED -> "blink2_patched";
                case APPLY_BLINK -> "apply_blink";
                case APPLY_BLINK2 -> "apply_blink2";
                case APPLY_PATCH -> "apply_patch";
            };
        }
    }
}

