/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_124;
import net.minecraft.class_151;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.screens.ETFConfigScreenWarnings;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.utils.ETFLruCache;

public abstract class ETFUtils2 {
    public static ETFLruCache<class_2960, class_1011> KNOWN_NATIVE_IMAGES = new ETFLruCache();

    @Nullable
    public static class_2960 replaceIdentifier(class_2960 id, String regex, String replace) {
        class_2960 forReturn;
        if (id == null) {
            return null;
        }
        try {
            forReturn = new class_2960(id.method_12836(), id.method_12832().replaceFirst(regex, replace));
        }
        catch (class_151 idFail) {
            ETFUtils2.logError(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.illegal_path_recommendation").getString() + "\n" + idFail);
            forReturn = null;
        }
        catch (Exception e) {
            forReturn = null;
        }
        return forReturn;
    }

    @Nullable
    public static String returnNameOfHighestPackFromTheseMultiple(String[] packNameList) {
        ArrayList<String> packNames = new ArrayList<String>(Arrays.asList(packNameList));
        while (packNames.size() >= 2) {
            if (ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(packNames.get(0)) >= ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(packNames.get(1))) {
                packNames.remove(1);
                continue;
            }
            packNames.remove(0);
        }
        return packNames.get(0);
    }

    public static boolean isNativeImageEmpty(@NotNull class_1011 image) {
        boolean foundNonEmptyPixel = false;
        for (int x = 0; x < image.method_4307(); ++x) {
            for (int y = 0; y < image.method_4323(); ++y) {
                if (image.method_4315(x, y) == 0) continue;
                foundNonEmptyPixel = true;
                break;
            }
            if (foundNonEmptyPixel) break;
        }
        return !foundNonEmptyPixel;
    }

    @Nullable
    public static String returnNameOfHighestPackFromTheseTwo(String[] packNameList) {
        if (packNameList.length != 2) {
            ETFUtils2.logError("highest pack check failed");
            return null;
        }
        if (packNameList[0].equals(packNameList[1])) {
            return packNameList[0];
        }
        if (ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(packNameList[0]) >= ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(packNameList[1])) {
            return packNameList[0];
        }
        return packNameList[1];
    }

    @Nullable
    public static Properties readAndReturnPropertiesElseNull(class_2960 path) {
        Properties props = new Properties();
        try {
            class_3298 resource = (class_3298)class_310.method_1551().method_1478().method_14486(path).get();
            try {
                InputStream in = resource.method_14482();
                props.load(in);
                in.close();
                return props;
            }
            catch (Exception e) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class_1011 getNativeImageElseNull(@Nullable class_2960 identifier) {
        if (identifier != null && KNOWN_NATIVE_IMAGES.get(identifier) != null) {
            return KNOWN_NATIVE_IMAGES.get(identifier);
        }
        try {
            InputStream in = ((class_3298)class_310.method_1551().method_1478().method_14486(identifier).get()).method_14482();
            try {
                class_1011 img = class_1011.method_4309((InputStream)in);
                in.close();
                KNOWN_NATIVE_IMAGES.put(identifier, img);
                return img;
            }
            catch (Exception e) {
                in.close();
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void logMessage(String obj) {
        ETFUtils2.logMessage(obj, false);
    }

    public static void logMessage(String obj, boolean inChat) {
        if (inChat) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                player.method_7353((class_2561)class_5250.method_43477((class_7417)new class_2585("[INFO] [Entity Texture Features]: " + obj)).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}), false);
            } else {
                ETFClientCommon.LOGGER.info(obj);
            }
        } else {
            ETFClientCommon.LOGGER.info(obj);
        }
    }

    public static void logWarn(String obj) {
        ETFUtils2.logWarn(obj, false);
    }

    public static void logWarn(String obj, boolean inChat) {
        if (inChat) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                player.method_7353((class_2561)class_5250.method_43477((class_7417)new class_2585("[WARN] [Entity Texture Features]: " + obj)).method_27692(class_124.field_1054), false);
            } else {
                ETFClientCommon.LOGGER.warn(obj);
            }
        } else {
            ETFClientCommon.LOGGER.warn(obj);
        }
    }

    public static void logError(String obj) {
        ETFUtils2.logError(obj, false);
    }

    public static void logError(String obj, boolean inChat) {
        if (inChat) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                player.method_7353((class_2561)class_5250.method_43477((class_7417)new class_2585("[ERROR] [Entity Texture Features]: " + obj)).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), false);
            } else {
                ETFClientCommon.LOGGER.error(obj);
            }
        } else {
            ETFClientCommon.LOGGER.error(obj);
        }
    }

    public static void saveConfig() {
        File config = new File(ETFClientCommon.CONFIG_DIR, "entity_texture_features.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!config.getParentFile().exists()) {
            config.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(config);
            fileWriter.write(gson.toJson((Object)ETFClientCommon.ETFConfigData));
            fileWriter.close();
        }
        catch (IOException e) {
            ETFUtils2.logError("Config file could not be saved", false);
        }
    }

    public static class_1011 emptyNativeImage() {
        return ETFUtils2.emptyNativeImage(64, 64);
    }

    public static class_1011 emptyNativeImage(int Width, int Height) {
        class_1011 empty = new class_1011(Width, Height, false);
        empty.method_4326(0, 0, Width, Height, 0);
        return empty;
    }

    public static boolean registerNativeImageToIdentifier(class_1011 img, class_2960 identifier) {
        if (img != null && identifier != null) {
            class_1043 bob = new class_1043(img);
            class_310.method_1551().method_1531().method_4616(identifier, (class_1044)bob);
            KNOWN_NATIVE_IMAGES.put(identifier, img);
            return true;
        }
        ETFUtils2.logError("registering native image failed: " + img + ", " + identifier);
        return false;
    }

    public static void checkModCompatibility() {
        if (ETFVersionDifferenceHandler.isThisModLoaded("figura") && !ETFClientCommon.ETFConfigData.ignoredConfigs.contains((Object)ETFConfigScreenWarnings.ConfigWarning.FIGURA)) {
            ETFClientCommon.ETFConfigData.skinFeaturesEnabled = false;
            ETFUtils2.saveConfig();
        }
    }
}

