/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu;

import com.google.common.collect.LinkedListMultimap;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.config.ModMenuConfigManager;
import com.terraformersmc.modmenu.event.ModMenuEventHandler;
import com.terraformersmc.modmenu.util.ModrinthUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.fabric.FabricDummyParentMod;
import com.terraformersmc.modmenu.util.mod.fabric.FabricMod;
import com.terraformersmc.modmenu.util.mod.quilt.QuiltMod;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModMenu
implements ClientModInitializer {
    public static final String MOD_ID = "modmenu";
    public static final String GITHUB_REF = "TerraformersMC/ModMenu";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu");
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    public static final Gson GSON_MINIFIED = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    public static final Map<String, Mod> MODS = new HashMap<String, Mod>();
    public static final Map<String, Mod> ROOT_MODS = new HashMap<String, Mod>();
    public static final LinkedListMultimap<Mod, Mod> PARENT_MAP = LinkedListMultimap.create();
    public static boolean modUpdateAvailable = false;
    private static Map<String, ConfigScreenFactory<?>> configScreenFactories = new HashMap();
    private static List<Map<String, ConfigScreenFactory<?>>> delayedScreenFactoryProviders = new ArrayList();
    private static int cachedDisplayedModCount = -1;
    public static boolean runningQuilt = false;

    public static class_437 getConfigScreen(String modid, class_437 menuScreen) {
        if (!delayedScreenFactoryProviders.isEmpty()) {
            delayedScreenFactoryProviders.forEach(map -> map.forEach(configScreenFactories::putIfAbsent));
            delayedScreenFactoryProviders.clear();
        }
        if (ModMenuConfig.HIDDEN_CONFIGS.getValue().contains(modid)) {
            return null;
        }
        ConfigScreenFactory<?> factory = configScreenFactories.get(modid);
        if (factory != null) {
            return factory.create(menuScreen);
        }
        return null;
    }

    public void onInitializeClient() {
        ModMenuConfigManager.initializeConfig();
        HashSet<String> modpackMods = new HashSet<String>();
        FabricLoader.getInstance().getEntrypointContainers(MOD_ID, ModMenuApi.class).forEach(entrypoint -> {
            ModMetadata metadata = entrypoint.getProvider().getMetadata();
            String modId = metadata.getId();
            try {
                ModMenuApi api = (ModMenuApi)entrypoint.getEntrypoint();
                configScreenFactories.put(modId, api.getModConfigScreenFactory());
                delayedScreenFactoryProviders.add(api.getProvidedConfigScreenFactories());
                api.attachModpackBadges(modpackMods::add);
            }
            catch (Throwable e) {
                LOGGER.error("Mod {} provides a broken implementation of ModMenuApi", (Object)modId, (Object)e);
            }
        });
        for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            Mod mod;
            if (ModMenuConfig.HIDDEN_MODS.getValue().contains(modContainer.getMetadata().getId())) continue;
            if (FabricLoader.getInstance().isModLoaded("quilt_loader")) {
                mod = new QuiltMod(modContainer, modpackMods);
                MODS.put(((FabricMod)mod).getId(), mod);
                continue;
            }
            mod = new FabricMod(modContainer, modpackMods);
            MODS.put(((FabricMod)mod).getId(), mod);
        }
        if (ModMenuConfig.UPDATE_CHECKER.getValue()) {
            ModrinthUtil.checkForUpdates();
        }
        HashMap<String, Mod> dummyParents = new HashMap<String, Mod>();
        for (Mod mod : MODS.values()) {
            String parentId = mod.getParent();
            if (parentId != null) {
                Mod parent = MODS.getOrDefault(parentId, (Mod)dummyParents.get(parentId));
                if (parent == null && mod instanceof FabricMod) {
                    parent = new FabricDummyParentMod((FabricMod)mod, parentId);
                    dummyParents.put(parentId, parent);
                }
                PARENT_MAP.put((Object)parent, (Object)mod);
                continue;
            }
            ROOT_MODS.put(mod.getId(), mod);
        }
        MODS.putAll(dummyParents);
        ModMenuEventHandler.register();
    }

    public static void clearModCountCache() {
        cachedDisplayedModCount = -1;
    }

    public static String getDisplayedModCount() {
        if (cachedDisplayedModCount == -1) {
            cachedDisplayedModCount = Math.toIntExact(MODS.values().stream().filter(mod -> !(!ModMenuConfig.COUNT_CHILDREN.getValue() && mod.getParent() != null || !ModMenuConfig.COUNT_LIBRARIES.getValue() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY) || !ModMenuConfig.COUNT_HIDDEN_MODS.getValue() && ModMenuConfig.HIDDEN_MODS.getValue().contains(mod.getId()))).count());
        }
        return NumberFormat.getInstance().format(cachedDisplayedModCount);
    }

    public static class_2561 createModsButtonText(boolean title) {
        boolean isIcon;
        ModMenuConfig.TitleMenuButtonStyle titleStyle = ModMenuConfig.MODS_BUTTON_STYLE.getValue();
        ModMenuConfig.GameMenuButtonStyle gameMenuStyle = ModMenuConfig.GAME_MENU_BUTTON_STYLE.getValue();
        boolean bl = title ? titleStyle == ModMenuConfig.TitleMenuButtonStyle.ICON : (isIcon = gameMenuStyle == ModMenuConfig.GameMenuButtonStyle.ICON);
        boolean isShort = title ? titleStyle == ModMenuConfig.TitleMenuButtonStyle.SHRINK : gameMenuStyle == ModMenuConfig.GameMenuButtonStyle.REPLACE_BUGS;
        class_5250 modsText = class_2561.method_43471((String)"modmenu.title");
        if (ModMenuConfig.MOD_COUNT_LOCATION.getValue().isOnModsButton() && !isIcon) {
            String count = ModMenu.getDisplayedModCount();
            if (isShort) {
                modsText.method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43469((String)"modmenu.loaded.short", (Object[])new Object[]{count}));
            } else {
                Object key;
                String specificKey = "modmenu.loaded." + count;
                Object object = key = class_1074.method_4663((String)specificKey) ? specificKey : "modmenu.loaded";
                if (ModMenuConfig.EASTER_EGGS.getValue() && class_1074.method_4663((String)(specificKey + ".secret"))) {
                    key = specificKey + ".secret";
                }
                modsText.method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43469((String)key, (Object[])new Object[]{count}));
            }
        }
        return modsText;
    }
}

