/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import info.journeymap.shaded.org.jetbrains.annotations.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.mod.IBlockColorProxy;
import journeymap.client.mod.IBlockSpritesProxy;
import journeymap.client.mod.ModBlockDelegate;
import journeymap.client.model.BlockFlag;
import journeymap.client.model.ChunkMD;
import journeymap.client.world.JmBlockAccess;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_7923;
import org.apache.logging.log4j.Logger;

public class BlockMD
implements Comparable<BlockMD> {
    public static final EnumSet<BlockFlag> FlagsPlantAndCrop = EnumSet.of(BlockFlag.Plant, BlockFlag.Crop);
    public static final EnumSet<BlockFlag> FlagsNormal = EnumSet.complementOf(EnumSet.of(BlockFlag.Error, BlockFlag.Ignore));
    public static final BlockMD AIRBLOCK = new BlockMD(class_2246.field_10124.method_9564(), "minecraft:air", "0", "Air", Float.valueOf(0.0f), EnumSet.of(BlockFlag.Ignore), false);
    public static final BlockMD VOIDBLOCK = new BlockMD(class_2246.field_10124.method_9564(), "journeymap:void", "0", "Void", Float.valueOf(0.0f), EnumSet.of(BlockFlag.Ignore), false);
    private static Logger LOGGER = Journeymap.getLogger();
    private final class_2680 blockState;
    private final String blockId;
    private final String blockStateId;
    private final String name;
    private EnumSet<BlockFlag> flags;
    private Integer color;
    private float alpha;
    private IBlockSpritesProxy blockSpritesProxy;
    private IBlockColorProxy blockColorProxy;
    private boolean noShadow;
    private boolean isIgnore;
    private boolean isWater;
    private boolean isLava;
    private boolean isFluid;
    private boolean isFire;
    private boolean isIce;
    private boolean isFoliage;
    private boolean isGrass;
    private boolean isPlantOrCrop;
    private boolean isError;

    private BlockMD(@NotNull class_2680 blockState) {
        this(blockState, BlockMD.getBlockId(blockState), BlockMD.getBlockStateId(blockState), BlockMD.getBlockName(blockState));
    }

    private BlockMD(@NotNull class_2680 blockState, String blockId, String blockStateId, String name) {
        this(blockState, blockId, blockStateId, name, Float.valueOf(1.0f), EnumSet.noneOf(BlockFlag.class), true);
    }

    private BlockMD(@NotNull class_2680 blockState, String blockId, String blockStateId, String name, Float alpha, EnumSet<BlockFlag> flags, boolean initDelegates) {
        this.blockState = blockState;
        this.blockId = blockId;
        this.blockStateId = blockStateId;
        this.name = name;
        this.alpha = alpha.floatValue();
        this.flags = flags;
        if (initDelegates) {
            ModBlockDelegate.INSTANCE.initialize(this);
        }
        this.updateProperties();
    }

    public Set<BlockMD> getValidStateMDs() {
        return this.getBlock().method_9595().method_11662().stream().map(BlockMD::get).collect(Collectors.toSet());
    }

    private void updateProperties() {
        boolean bl = this.isIgnore = this.blockState == null || this.hasFlag(BlockFlag.Ignore) && !this.hasFlag(BlockFlag.Force) || this.blockState.method_26204() instanceof class_2189 && !this.hasFlag(BlockFlag.Force) || this.blockState.method_26217() == class_2464.field_11455 && !(this.blockState.method_26204() instanceof class_2404);
        if (this.isIgnore) {
            this.color = -1;
            this.setAlpha(0.0f);
            this.flags.add(BlockFlag.Ignore);
            this.flags.add(BlockFlag.OpenToSky);
            this.flags.add(BlockFlag.NoShadow);
        }
        if (this.blockState != null) {
            class_2248 block = this.blockState.method_26204();
            this.isLava = block == class_2246.field_10164 || class_7923.field_41175.method_10221((Object)block).method_12832().equalsIgnoreCase("flowing_lava");
            this.isIce = block == class_2246.field_10295;
            this.isFire = block == class_2246.field_10036;
        }
        this.isFluid = this.hasFlag(BlockFlag.Fluid);
        this.isWater = this.hasFlag(BlockFlag.Water);
        this.noShadow = this.hasFlag(BlockFlag.NoShadow);
        this.isFoliage = this.hasFlag(BlockFlag.Foliage);
        this.isGrass = this.hasFlag(BlockFlag.Grass);
        this.isPlantOrCrop = this.hasAnyFlag(FlagsPlantAndCrop);
        this.isError = this.hasFlag(BlockFlag.Error);
    }

    public class_2248 getBlock() {
        return this.blockState.method_26204();
    }

    public static void reset() {
        DataCache.INSTANCE.resetBlockMetadata();
    }

    public static Set<BlockMD> getAll() {
        return StreamSupport.stream(class_2248.field_10651.spliterator(), false).map(BlockMD::get).collect(Collectors.toSet());
    }

    public static Set<BlockMD> getAllValid() {
        return BlockMD.getAll().stream().filter(blockMD -> !blockMD.isIgnore() && !blockMD.hasFlag(BlockFlag.Error)).collect(Collectors.toSet());
    }

    public static Set<BlockMD> getAllMinecraft() {
        return StreamSupport.stream(class_2248.field_10651.spliterator(), false).filter(blockState1 -> class_7923.field_41175.method_10221((Object)blockState1.method_26204()).method_12836().equals("minecraft")).map(BlockMD::get).collect(Collectors.toSet());
    }

    public static BlockMD getBlockMDFromChunkLocal(ChunkMD chunkMd, int localX, int y, int localZ) {
        return BlockMD.getBlockMD(chunkMd, chunkMd.getBlockPos(localX, y, localZ));
    }

    public static BlockMD getBlockMD(ChunkMD chunkMd, class_2338 blockPos) {
        try {
            if (blockPos.method_10264() >= chunkMd.getMinY()) {
                class_2680 blockState = chunkMd != null && chunkMd.hasChunk() ? chunkMd.getChunkBlockState(blockPos) : JmBlockAccess.INSTANCE.method_8320(blockPos);
                return BlockMD.get(blockState);
            }
            return VOIDBLOCK;
        }
        catch (Exception e) {
            LOGGER.error(String.format("Can't get blockId/meta for chunk %s,%s at %s : %s", chunkMd.getChunk().method_12004().field_9181, chunkMd.getChunk().method_12004().field_9180, blockPos, LogFormatter.toString(e)));
            return AIRBLOCK;
        }
    }

    public static BlockMD get(class_2680 blockState) {
        return DataCache.INSTANCE.getBlockMD(blockState);
    }

    public static String getBlockId(BlockMD blockMD) {
        return BlockMD.getBlockId(blockMD.getBlockState());
    }

    public static String getBlockId(class_2680 blockState) {
        return class_7923.field_41175.method_10221((Object)blockState.method_26204()).toString();
    }

    public static String getBlockStateId(BlockMD blockMD) {
        return BlockMD.getBlockStateId(blockMD.getBlockState());
    }

    public static String getBlockStateId(class_2680 blockState) {
        Collection properties = blockState.method_28501();
        if (properties.isEmpty()) {
            return Integer.toString(class_2248.method_9507((class_2680)blockState));
        }
        return Joiner.on((String)",").join((Iterable)properties);
    }

    private static String getBlockName(class_2680 blockState) {
        String displayName = null;
        try {
            class_2248 block = blockState.method_26204();
            class_1792 item = class_1792.method_7867((class_2248)block);
            if (item != null) {
                class_1799 idPicked = new class_1799((class_1935)item, 1);
                displayName = item.method_7864(idPicked).getString();
            }
            if (Strings.isNullOrEmpty(displayName)) {
                block.method_9518().getString();
            }
        }
        catch (Exception e) {
            LOGGER.debug(String.format("Couldn't get display name for %s: %s ", blockState, e));
        }
        if (Strings.isNullOrEmpty(displayName) || displayName.contains("tile")) {
            displayName = blockState.method_26204().getClass().getSimpleName().replaceAll("Block", "");
        }
        return displayName;
    }

    public static String getBlockName(class_2248 block) {
        String displayName = null;
        try {
            class_1792 item = (class_1792)class_1792.field_8003.get(block);
            if (item != null) {
                class_1799 idPicked = new class_1799((class_1935)item, 1);
                displayName = item.method_7864(idPicked).getString();
            }
            if (Strings.isNullOrEmpty(displayName)) {
                displayName = block.method_9518().getString();
            }
        }
        catch (Exception e) {
            LOGGER.debug(String.format("Couldn't get display name for %s: %s ", block, e));
        }
        if (Strings.isNullOrEmpty(displayName) || displayName.contains("tile")) {
            displayName = block.getClass().getSimpleName().replaceAll("Block", "");
        }
        return displayName;
    }

    public static void setAllFlags(class_2248 block, BlockFlag ... flags) {
        BlockMD defaultBlockMD = BlockMD.get(block.method_9564());
        for (BlockMD blockMD : defaultBlockMD.getValidStateMDs()) {
            blockMD.addFlags(flags);
        }
        LOGGER.debug(block.method_9518() + " flags set: " + flags);
    }

    public boolean hasFlag(BlockFlag checkFlag) {
        return this.flags.contains((Object)checkFlag);
    }

    public boolean hasAnyFlag(EnumSet<BlockFlag> checkFlags) {
        for (BlockFlag flag : checkFlags) {
            if (!this.flags.contains((Object)flag)) continue;
            return true;
        }
        return false;
    }

    public void addFlags(BlockFlag ... addFlags) {
        Collections.addAll(this.flags, addFlags);
        this.updateProperties();
    }

    public void removeFlags(BlockFlag ... removeFlags) {
        for (BlockFlag flag : removeFlags) {
            this.flags.remove((Object)flag);
        }
        this.updateProperties();
    }

    public void removeFlags(Collection<BlockFlag> removeFlags) {
        this.flags.removeAll(removeFlags);
        this.updateProperties();
    }

    public void addFlags(Collection<BlockFlag> addFlags) {
        this.flags.addAll(addFlags);
        this.updateProperties();
    }

    public int getBlockColor(ChunkMD chunkMD, class_2338 blockPos) {
        return this.blockColorProxy.getBlockColor(chunkMD, this, blockPos);
    }

    public int getTextureColor(@Nullable ChunkMD chunkMD, @Nullable class_2338 blockPos) {
        if (this.color == null && !this.isError && this.blockColorProxy != null) {
            this.color = this.blockColorProxy.deriveBlockColor(this, chunkMD, blockPos);
        }
        if (this.color == null) {
            this.color = 0;
        }
        return this.color;
    }

    public int getTextureColor() {
        return this.getTextureColor(null, null);
    }

    public void clearColor() {
        this.color = null;
    }

    public int setColor(int baseColor) {
        this.color = baseColor;
        return baseColor;
    }

    public boolean hasColor() {
        return this.color != null;
    }

    public void setBlockSpritesProxy(IBlockSpritesProxy blockSpritesProxy) {
        this.blockSpritesProxy = blockSpritesProxy;
    }

    public IBlockSpritesProxy getBlockSpritesProxy() {
        return this.blockSpritesProxy;
    }

    public void setBlockColorProxy(IBlockColorProxy blockColorProxy) {
        this.blockColorProxy = blockColorProxy;
    }

    public IBlockColorProxy getBlockColorProxy() {
        return this.blockColorProxy;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
        if (alpha < 1.0f) {
            this.flags.add(BlockFlag.Transparency);
        } else {
            this.flags.remove((Object)BlockFlag.Transparency);
        }
    }

    public boolean hasNoShadow() {
        if (this.noShadow) {
            return true;
        }
        return this.isPlantOrCrop && JourneymapClient.getInstance().getCoreProperties().mapPlantShadows.get() == false;
    }

    public class_2680 getBlockState() {
        return this.blockState;
    }

    public boolean hasTransparency() {
        return this.alpha < 1.0f;
    }

    public boolean isIgnore() {
        return this.isIgnore;
    }

    public boolean isIce() {
        return this.isIce;
    }

    public boolean isWater() {
        return this.isWater;
    }

    public boolean isFluid() {
        return this.isFluid;
    }

    public boolean isLava() {
        return this.isLava;
    }

    public boolean isFire() {
        return this.isFire;
    }

    public boolean isFoliage() {
        return this.isFoliage;
    }

    public boolean isGrass() {
        return this.isGrass;
    }

    public String getName() {
        return this.name;
    }

    public String getBlockId() {
        return this.blockId;
    }

    public String getBlockStateId() {
        return this.blockStateId;
    }

    public String getBlockDomain() {
        return class_7923.field_41175.method_10221((Object)this.getBlock()).method_12836();
    }

    public EnumSet<BlockFlag> getFlags() {
        return this.flags;
    }

    public boolean isVanillaBlock() {
        return this.getBlockDomain().equals("minecraft");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockMD)) {
            return false;
        }
        BlockMD blockMD = (BlockMD)o;
        return Objects.equal((Object)this.getBlockId(), (Object)blockMD.getBlockId()) && Objects.equal((Object)this.getBlockStateId(), (Object)blockMD.getBlockStateId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getBlockId(), this.getBlockStateId()});
    }

    public String toString() {
        return String.format("BlockMD [%s] (%s)", this.blockState, Joiner.on((String)",").join(this.flags));
    }

    @Override
    public int compareTo(BlockMD that) {
        Ordering ordering = Ordering.natural().nullsLast();
        return ComparisonChain.start().compare((Object)this.blockId, (Object)that.blockId, (Comparator)ordering).compare((Object)this.blockStateId, (Object)that.blockStateId, (Comparator)ordering).result();
    }

    public static class CacheLoader
    extends com.google.common.cache.CacheLoader<class_2680, BlockMD> {
        public BlockMD load(@NotNull class_2680 blockState) throws Exception {
            try {
                if (blockState == null || blockState.method_26217() == class_2464.field_11455 && !(blockState.method_26204() instanceof class_2404)) {
                    return AIRBLOCK;
                }
                if (class_7923.field_41175.method_10221((Object)blockState.method_26204()) == null) {
                    LOGGER.warn("Unregistered block will be treated like air: " + blockState);
                    return AIRBLOCK;
                }
                return new BlockMD(blockState);
            }
            catch (Exception e) {
                LOGGER.error(String.format("Can't get BlockMD for %s : %s", blockState, LogFormatter.toPartialString(e)));
                return AIRBLOCK;
            }
        }
    }
}

