/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.ingame;

import java.util.Collection;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.draw.MatrixDrawUtil;
import journeymap.client.render.ingame.WaypointRenderTypes;
import journeymap.client.texture.Texture;
import journeymap.client.texture.TextureCache;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_822;
import net.minecraft.class_898;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class WaypointRenderer {
    private WaypointProperties waypointProperties;
    private class_310 minecraft = class_310.method_1551();
    private class_898 renderManager = this.minecraft.method_1561();
    private static WaypointRenderer INSTANCE;

    private WaypointRenderer() {
    }

    public static WaypointRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WaypointRenderer();
        }
        return INSTANCE;
    }

    public void renderAllWaypoints(class_4587 poseStack) {
        this.renderAllWaypoints(poseStack, false);
    }

    public void renderAllWaypoints(class_4587 poseStack, boolean shaderBeacon) {
        class_276 worldRendererFramebuffer;
        this.waypointProperties = JourneymapClient.getInstance().getWaypointProperties();
        Collection<Waypoint> waypoints = WaypointStore.INSTANCE.getAll();
        String playerDim = this.minecraft.field_1724.method_37908().method_27983().method_29177().toString();
        if (class_310.method_29611() && !JourneymapClient.getInstance().hasOptifine && !this.waypointProperties.shaderBeacon.get().booleanValue() && (worldRendererFramebuffer = this.minecraft.field_1769.method_29360()) != null) {
            class_276 framebuffer = this.minecraft.method_1522();
            RenderWrapper.bindFramebuffer(36008, worldRendererFramebuffer.field_1476);
            RenderWrapper.bindFramebuffer(36009, framebuffer.field_1476);
            RenderWrapper.blitFramebuffer(0, 0, worldRendererFramebuffer.field_1482, worldRendererFramebuffer.field_1481, 0, 0, framebuffer.field_1482, framebuffer.field_1481, 256, 9728);
        }
        for (Waypoint waypoint : waypoints) {
            if (!this.canDrawWaypoint(waypoint, playerDim) || this.waypointProperties.shaderBeacon.get().booleanValue() && !this.waypointProperties.showRotatingBeam.get().booleanValue() && !this.waypointProperties.showStaticBeam.get().booleanValue() && shaderBeacon) continue;
            try {
                class_4597.class_4598 buffers = this.minecraft.method_22940().method_23000();
                poseStack.method_22903();
                this.render(waypoint, poseStack, (class_4597)buffers, shaderBeacon);
                poseStack.method_22909();
                buffers.method_22993();
            }
            catch (Exception t) {
                Journeymap.getLogger().error("EntityWaypoint failed to render for " + waypoint + ": ", (Throwable)t);
            }
        }
    }

    private boolean canDrawWaypoint(Waypoint waypoint, String playerDim) {
        return (Waypoint.Origin.EXTERNAL_FORCE.getValue().equals(waypoint.getOrigin()) || waypoint.isEnable() && JourneymapClient.getInstance().getWaypointProperties().beaconEnabled.get() != false && JourneymapClient.getInstance().getStateHandler().canShowInGameBeacons() && JourneymapClient.getInstance().getStateHandler().isWaypointsAllowed()) && waypoint.getDimensions().contains(playerDim);
    }

    private void render(Waypoint waypoint, class_4587 poseStack, class_4597 buffers, boolean shaderBeacon) {
        float partialTicks = this.minecraft.method_1488();
        boolean onlyBeacon = JourneymapClient.getInstance().getWaypointProperties().shaderBeacon.get() != false && shaderBeacon;
        boolean skipBeacon = JourneymapClient.getInstance().getWaypointProperties().shaderBeacon.get() != false && !shaderBeacon;
        long gameTime = this.minecraft.field_1687.method_8510();
        float fadeAlpha = 1.0f;
        class_243 waypointVec = waypoint.getPosition().method_1031(0.0, 0.118, 0.0);
        class_243 playerVec = this.minecraft.field_1724.method_19538();
        double actualDistance = playerVec.method_1022(waypointVec);
        int maxDistance = this.waypointProperties.maxDistance.get();
        int minDistance = this.waypointProperties.minDistance.get();
        float[] rgba = RGB.floats(waypoint.getColor(), fadeAlpha * 0.4f);
        double viewX = this.renderManager.field_4686.method_19326().method_10216();
        double viewY = this.renderManager.field_4686.method_19326().method_10214();
        double viewZ = this.renderManager.field_4686.method_19326().method_10215();
        boolean showStaticInnerBeam = this.waypointProperties.showStaticBeam.get();
        boolean showRotatingOuterBeam = this.waypointProperties.showRotatingBeam.get();
        double viewDistance = actualDistance;
        double maxRenderDistance = (Integer)this.minecraft.field_1690.method_42503().method_41753() * 16;
        if (maxDistance > 0 && actualDistance > (double)maxDistance) {
            return;
        }
        if (waypoint.isDeathPoint() && this.waypointProperties.autoRemoveDeathpoints.get().booleanValue() && actualDistance < (double)this.waypointProperties.autoRemoveDeathpointDistance.get().intValue() && actualDistance > 1.5) {
            Journeymap.getLogger().debug("Auto removing deathpoint " + waypoint);
            WaypointStore.INSTANCE.remove(waypoint, true);
            return;
        }
        if (Waypoint.Origin.TEMP.getValue().equals(waypoint.getOrigin()) && (actualDistance <= (double)this.waypointProperties.autoRemoveTempWaypoints.get().intValue() || actualDistance <= (double)(minDistance + 4)) && actualDistance > 1.5) {
            Journeymap.getLogger().debug("Auto removing temp waypoint " + waypoint);
            WaypointStore.INSTANCE.remove(waypoint, true);
        }
        if (minDistance > 0) {
            if ((int)actualDistance <= minDistance) {
                return;
            }
            if ((int)actualDistance <= minDistance + 4) {
                fadeAlpha = Math.min((float)(actualDistance - (double)minDistance) / 3.0f, 1.0f);
            }
        }
        if (viewDistance > maxRenderDistance) {
            class_243 delta = waypointVec.method_1020(playerVec).method_1029();
            waypointVec = playerVec.method_1031(delta.field_1352 * maxRenderDistance, delta.field_1351 * maxRenderDistance, delta.field_1350 * maxRenderDistance);
            viewDistance = maxRenderDistance;
        }
        double scale = 0.00390625 * ((viewDistance + 4.0) / 3.0);
        double shiftX = waypointVec.field_1352 - viewX;
        double shiftY = waypointVec.field_1351 - viewY;
        double shiftZ = waypointVec.field_1350 - viewZ;
        if ((showStaticInnerBeam || showRotatingOuterBeam) && (onlyBeacon || !skipBeacon)) {
            poseStack.method_22903();
            poseStack.method_22904(shiftX, -180.0, shiftZ);
            WaypointRenderer.renderBeamSegment(poseStack, buffers, partialTicks, gameTime, 1, 360, rgba, 0.2f, 0.25f, showStaticInnerBeam, showRotatingOuterBeam);
            poseStack.method_22909();
            if (onlyBeacon) {
                return;
            }
        }
        if (this.lookingAtBeacon(waypointVec) && viewDistance > 0.5) {
            poseStack.method_22903();
            this.renderNameTag(waypoint, poseStack, buffers, fadeAlpha, scale, actualDistance, shiftX, shiftY, shiftZ);
            poseStack.method_22909();
        }
        if (this.lookingAtBeacon(waypointVec) && viewDistance > 0.5 && waypoint.showDeviation() && this.waypointProperties.showDeviationLabel.get().booleanValue()) {
            poseStack.method_22903();
            this.renderDeviation(waypoint, poseStack, buffers, fadeAlpha, scale, shiftX, shiftY, shiftZ, playerVec, waypointVec);
            poseStack.method_22909();
        }
        if (viewDistance > 0.1 && this.waypointProperties.showTexture.get().booleanValue()) {
            poseStack.method_22903();
            this.renderIcon(waypoint, poseStack, buffers, fadeAlpha, scale, shiftX, shiftY, shiftZ);
            poseStack.method_22909();
        }
    }

    private void renderIcon(Waypoint waypoint, class_4587 poseStack, class_4597 buffers, float alpha, double scale, double shiftX, double shiftY, double shiftZ) {
        int n = this.waypointProperties.textureSmall.get() != false ? 2 : 4;
        poseStack.method_22903();
        poseStack.method_22904(shiftX, shiftY, shiftZ);
        poseStack.method_22907(this.renderManager.field_4686.method_23767());
        poseStack.method_22905((float)(-(scale *= (double)n)), (float)(-scale), (float)scale);
        Texture texture = TextureCache.getWaypointIcon(waypoint.getTextureResource());
        class_2960 location = texture.getLocation() == null ? waypoint.getTextureResource() : texture.getLocation();
        class_4588 vertexBuilder = buffers.getBuffer(WaypointRenderTypes.getIcon(location));
        RenderWrapper.setShader(class_757::method_34541);
        RenderWrapper.activeTexture(33984);
        RenderWrapper.bindTexture(texture.getTextureId());
        RenderWrapper.setShaderTexture(0, location);
        MatrixDrawUtil.drawColoredImage(waypoint.getTexture(), poseStack, vertexBuilder, waypoint.getIconColor(), alpha, (double)(-(waypoint.getTexture().getWidth() >> 1)) + 0.5, (double)(-(waypoint.getTexture().getHeight() >> 1)) + 0.2, 0.0);
        poseStack.method_22909();
    }

    private void renderDeviation(Waypoint waypoint, class_4587 poseStack, class_4597 buffers, float alpha, double scale, double shiftX, double shiftY, double shiftZ, class_243 playerVec, class_243 waypointVec) {
        StringBuilder sb = new StringBuilder();
        class_243 vecTo = playerVec.method_1035(waypointVec);
        if (this.waypointProperties.boldLabel.get().booleanValue()) {
            sb.append(class_124.field_1067);
        }
        sb.append(String.format("x:%d, y:%d, z:%d", (int)vecTo.field_1352, (int)vecTo.field_1351, (int)vecTo.field_1350));
        double labelY = (waypoint.getTexture().getHeight() >> 1) + 35;
        this.renderWaypointLabel(sb.toString(), waypoint, labelY, poseStack, buffers, alpha, scale, shiftX, shiftY, shiftZ);
    }

    private void renderNameTag(Waypoint waypoint, class_4587 poseStack, class_4597 buffers, float alpha, double scale, double actualDistance, double shiftX, double shiftY, double shiftZ) {
        String distanceLabel = Constants.getString("jm.waypoint.distance_meters", "%1.0f");
        String label = waypoint.getName();
        boolean showName = this.waypointProperties.showName.get() != false && label != null && label.length() > 0;
        boolean showDistance = this.waypointProperties.showDistance.get();
        if (showName || showDistance) {
            StringBuilder sb = new StringBuilder();
            if (this.waypointProperties.boldLabel.get().booleanValue()) {
                sb.append(class_124.field_1067);
            }
            if (showName) {
                sb.append(label);
            }
            if (showName && showDistance) {
                sb.append(" ");
            }
            if (showDistance) {
                sb.append(String.format(distanceLabel, actualDistance));
            }
            if (sb.length() > 0) {
                label = sb.toString();
                double labelY = -(waypoint.getTexture().getHeight() >> 1) - 8;
                this.renderWaypointLabel(label, waypoint, labelY, poseStack, buffers, alpha, scale, shiftX, shiftY, shiftZ);
            }
        }
    }

    private void renderWaypointLabel(String label, Waypoint waypoint, double labelY, class_4587 poseStack, class_4597 buffers, float alpha, double scale, double shiftX, double shiftY, double shiftZ) {
        poseStack.method_22903();
        poseStack.method_22904(shiftX, shiftY, shiftZ);
        poseStack.method_22907(this.renderManager.field_4686.method_23767());
        poseStack.method_22905((float)(-scale), (float)(-scale), (float)scale);
        float fontScale = this.waypointProperties.fontScale.get().floatValue();
        DrawUtil.drawBatchLabel(poseStack, (class_2561)class_2561.method_43470((String)label), buffers, 1.0, labelY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, -16777216, 0.6f * alpha, waypoint.getSafeColor(), alpha, fontScale, false);
        DrawUtil.drawBatchLabel(poseStack, (class_2561)class_2561.method_43470((String)label), buffers, 1.0, labelY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, -16777216, 0.4f * alpha, waypoint.getSafeColor(), alpha, fontScale, false);
        poseStack.method_22909();
    }

    private boolean lookingAtBeacon(class_243 waypointVec) {
        if (this.waypointProperties.autoHideLabel.get().booleanValue()) {
            double playerYaw;
            int angle = 5;
            double yaw = Math.atan2(this.renderManager.field_4686.method_19326().method_10215() - waypointVec.field_1350, this.renderManager.field_4686.method_19326().method_10216() - waypointVec.field_1352);
            double degrees = Math.toDegrees(yaw) + 90.0;
            if (degrees < 0.0) {
                degrees = 360.0 + degrees;
            }
            if ((playerYaw = (double)(this.minecraft.field_1719.method_5791() % 360.0f)) < 0.0) {
                playerYaw += 360.0;
            }
            playerYaw = Math.toRadians(playerYaw);
            double playerDegrees = Math.toDegrees(playerYaw);
            return !(Math.abs((degrees += (double)angle) + (double)angle - ((playerDegrees += (double)angle) + (double)angle)) > (double)angle);
        }
        return true;
    }

    public static void renderBeamSegment(class_4587 poseStack, class_4597 buffer, float partialTicks, long gameTime, int yOffset, int height, float[] colors, float beamRadius, float glowRadius, boolean showStaticInnerBeam, boolean showRotatingOuterBeam) {
        float texScale = 1.0f;
        int heightOffset = yOffset + height;
        float rotation = (float)Math.floorMod(gameTime, 40L) + partialTicks;
        float texOffset = -((float)(-gameTime) * 0.2f - (float)class_3532.method_15375((float)((float)(-gameTime) * 0.1f))) * 0.6f;
        float red = colors[0];
        float blue = colors[1];
        float green = colors[2];
        float alpha = colors[3];
        class_4588 beamBuffer = buffer.getBuffer(class_1921.method_23592((class_2960)class_822.field_4338, (boolean)true));
        poseStack.method_22903();
        if (!showStaticInnerBeam) {
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(rotation * 2.25f - 45.0f));
        }
        float V2 = -1.0f + texOffset;
        float innerV1 = (float)height * texScale * (0.5f / beamRadius) + V2;
        WaypointRenderer.renderPart(poseStack, beamBuffer, red, blue, green, alpha, yOffset, heightOffset, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius, 0.0f, 1.0f, innerV1, V2);
        poseStack.method_22909();
        float outerV1 = (float)height * texScale + V2;
        poseStack.method_22903();
        if (showRotatingOuterBeam) {
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(rotation * 2.25f - 45.0f));
        }
        WaypointRenderer.renderPart(poseStack, beamBuffer, red, blue, green, alpha, yOffset, heightOffset, -glowRadius, -glowRadius, glowRadius, -glowRadius, -glowRadius, glowRadius, glowRadius, glowRadius, 0.0f, 1.0f, outerV1, V2);
        poseStack.method_22909();
    }

    private static void renderPart(class_4587 poseStack, class_4588 buffer, float red, float green, float blue, float alpha, int yMin, int yMax, float p1, float p2, float p3, float p4, float p5, float p6, float p7, float p8, float u1, float u2, float v1, float v2) {
        class_4587.class_4665 entry = poseStack.method_23760();
        Matrix4f matrixPos = entry.method_23761();
        Matrix3f normal = entry.method_23762();
        WaypointRenderer.addQuad(matrixPos, normal, buffer, red, green, blue, alpha, yMin, yMax, p1, p2, p3, p4, u1, u2, v1, v2);
        WaypointRenderer.addQuad(matrixPos, normal, buffer, red, green, blue, alpha, yMin, yMax, p7, p8, p5, p6, u1, u2, v1, v2);
        WaypointRenderer.addQuad(matrixPos, normal, buffer, red, green, blue, alpha, yMin, yMax, p3, p4, p7, p8, u1, u2, v1, v2);
        WaypointRenderer.addQuad(matrixPos, normal, buffer, red, green, blue, alpha, yMin, yMax, p5, p6, p1, p2, u1, u2, v1, v2);
    }

    private static void addQuad(Matrix4f matrixPos, Matrix3f normal, class_4588 bufferIn, float red, float green, float blue, float alpha, int yMin, int yMax, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        MatrixDrawUtil.addVertexUV(matrixPos, normal, bufferIn, red, green, blue, alpha, yMax, x1, z1, u2, v1);
        MatrixDrawUtil.addVertexUV(matrixPos, normal, bufferIn, red, green, blue, alpha, yMin, x1, z1, u2, v2);
        MatrixDrawUtil.addVertexUV(matrixPos, normal, bufferIn, red, green, blue, alpha, yMin, x2, z2, u1, v2);
        MatrixDrawUtil.addVertexUV(matrixPos, normal, bufferIn, red, green, blue, alpha, yMax, x2, z2, u1, v1);
    }
}

