/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.task.multi;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.api.option.KeyedEnum;
import journeymap.client.data.DataCache;
import journeymap.client.model.MapType;
import journeymap.client.properties.CoreProperties;
import journeymap.common.Journeymap;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_310;

public class RenderSpec {
    private static DecimalFormat decFormat = new DecimalFormat("##.#");
    private static volatile RenderSpec lastSurfaceRenderSpec;
    private static volatile RenderSpec lastTopoRenderSpec;
    private static volatile RenderSpec lastUndergroundRenderSpec;
    private static class_310 minecraft;
    private final class_1657 player;
    private final MapType mapType;
    private final int primaryRenderDistance;
    private final int maxSecondaryRenderDistance;
    private final RevealShape revealShape;
    private ListMultimap<Integer, Offset> offsets = null;
    private ArrayList<class_1923> primaryRenderCoords;
    private Comparator<class_1923> comparator;
    private int lastSecondaryRenderDistance;
    private class_1923 lastPlayerCoord;
    private long lastTaskTime;
    private int lastTaskChunks;
    private double lastTaskAvgChunkTime;

    private RenderSpec(class_310 minecraft, MapType mapType) {
        this.player = minecraft.field_1724;
        CoreProperties props = JourneymapClient.getInstance().getCoreProperties();
        int gameRenderDistance = Math.max(1, minecraft.field_1690.method_38521() - 1);
        int mapRenderDistanceMax = mapType.isUnderground() ? props.renderDistanceCaveMax.get() : props.renderDistanceSurfaceMax.get();
        if (JourneymapClient.getInstance().getStateHandler().isJourneyMapServerConnection()) {
            int serverDistance = JourneymapClient.getInstance().getStateHandler().getMaxRenderDistance();
            int n = mapRenderDistanceMax = serverDistance == 0 ? mapRenderDistanceMax : Math.min(serverDistance, mapRenderDistanceMax);
        }
        if (mapRenderDistanceMax == 0) {
            mapRenderDistanceMax = gameRenderDistance;
        }
        Journeymap.getLogger().debug("Map Render distance set to: {}", (Object)mapRenderDistanceMax);
        this.mapType = mapType;
        int renderDistance = Math.min(gameRenderDistance, mapRenderDistanceMax);
        this.primaryRenderDistance = renderDistance++;
        this.maxSecondaryRenderDistance = renderDistance;
        this.revealShape = (RevealShape)((Object)JourneymapClient.getInstance().getCoreProperties().revealShape.get());
        this.lastPlayerCoord = new class_1923(minecraft.field_1724.method_31476().field_9181, minecraft.field_1724.method_31476().field_9180);
        this.lastSecondaryRenderDistance = this.primaryRenderDistance;
    }

    private static Double blockDistance(class_1923 playerCoord, class_1923 coord) {
        int x = (playerCoord.field_9181 << 4) + 8 - ((coord.field_9181 << 4) + 8);
        int z = (playerCoord.field_9180 << 4) + 8 - ((coord.field_9180 << 4) + 8);
        return Math.sqrt(x * x + z * z);
    }

    private static Double chunkDistance(class_1923 playerCoord, class_1923 coord) {
        int x = playerCoord.field_9181 - coord.field_9181;
        int z = playerCoord.field_9180 - coord.field_9180;
        return Math.sqrt(x * x + z * z);
    }

    static boolean inRange(class_1923 playerCoord, class_1923 coord, int renderDistance, RevealShape revealShape) {
        if (revealShape == RevealShape.Circle) {
            double distance = RenderSpec.blockDistance(playerCoord, coord);
            double diff = distance - (double)(renderDistance * 16);
            return diff <= 8.0;
        }
        float x = Math.abs(playerCoord.field_9181 - coord.field_9181);
        float z = Math.abs(playerCoord.field_9180 - coord.field_9180);
        return x <= (float)renderDistance && z <= (float)renderDistance;
    }

    private static ListMultimap<Integer, Offset> calculateOffsets(int minOffset, int maxOffset, RevealShape revealShape) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        boolean baseX = false;
        boolean baseZ = false;
        class_1923 baseCoord = new class_1923(0, 0);
        for (int offset = maxOffset; offset >= minOffset; --offset) {
            for (int x = 0 - offset; x <= 0 + offset; ++x) {
                for (int z = 0 - offset; z <= 0 + offset; ++z) {
                    class_1923 coord = new class_1923(x, z);
                    if (revealShape != RevealShape.Square && !RenderSpec.inRange(baseCoord, coord, offset, revealShape)) continue;
                    multimap.put((Object)offset, (Object)new Offset(coord.field_9181, coord.field_9180));
                }
            }
            if (offset >= maxOffset) continue;
            List oneUp = multimap.get((Object)(offset + 1));
            oneUp.removeAll(multimap.get((Object)offset));
        }
        for (int i = minOffset; i <= maxOffset; ++i) {
            multimap.get((Object)i).sort((o1, o2) -> Double.compare(o1.distance(), o2.distance()));
        }
        return new ImmutableListMultimap.Builder().putAll((Multimap)multimap).build();
    }

    public static RenderSpec getSurfaceSpec() {
        if (lastSurfaceRenderSpec == null || RenderSpec.lastSurfaceRenderSpec.lastPlayerCoord.field_9181 != RenderSpec.minecraft.field_1724.method_31476().field_9181 || RenderSpec.lastSurfaceRenderSpec.lastPlayerCoord.field_9180 != RenderSpec.minecraft.field_1724.method_31476().field_9180) {
            RenderSpec newSpec = new RenderSpec(minecraft, MapType.day(DataCache.getPlayer()));
            newSpec.copyLastStatsFrom(lastSurfaceRenderSpec);
            lastSurfaceRenderSpec = newSpec;
        }
        return lastSurfaceRenderSpec;
    }

    public static RenderSpec getTopoSpec() {
        if (lastTopoRenderSpec == null || RenderSpec.lastTopoRenderSpec.lastPlayerCoord.field_9181 != RenderSpec.minecraft.field_1724.method_31476().field_9181 || RenderSpec.lastTopoRenderSpec.lastPlayerCoord.field_9180 != RenderSpec.minecraft.field_1724.method_31476().field_9180) {
            RenderSpec newSpec = new RenderSpec(minecraft, MapType.topo(DataCache.getPlayer()));
            newSpec.copyLastStatsFrom(lastTopoRenderSpec);
            lastTopoRenderSpec = newSpec;
        }
        return lastTopoRenderSpec;
    }

    public static RenderSpec getUndergroundSpec() {
        if (lastUndergroundRenderSpec == null || RenderSpec.lastUndergroundRenderSpec.lastPlayerCoord.field_9181 != RenderSpec.minecraft.field_1724.method_31476().field_9181 || RenderSpec.lastUndergroundRenderSpec.lastPlayerCoord.field_9180 != RenderSpec.minecraft.field_1724.method_31476().field_9180) {
            RenderSpec newSpec = new RenderSpec(minecraft, MapType.underground(DataCache.getPlayer()));
            newSpec.copyLastStatsFrom(lastUndergroundRenderSpec);
            lastUndergroundRenderSpec = newSpec;
        }
        return lastUndergroundRenderSpec;
    }

    public static void resetRenderSpecs() {
        lastUndergroundRenderSpec = null;
        lastSurfaceRenderSpec = null;
        lastTopoRenderSpec = null;
    }

    protected List<class_1923> getRenderAreaCoords() {
        if (this.offsets == null) {
            this.offsets = RenderSpec.calculateOffsets(this.primaryRenderDistance, this.maxSecondaryRenderDistance, this.revealShape);
        }
        DataCache dataCache = DataCache.INSTANCE;
        if (this.lastPlayerCoord == null || this.lastPlayerCoord.field_9181 != this.player.method_31476().field_9181 || this.lastPlayerCoord.field_9180 != this.player.method_31476().field_9180) {
            this.primaryRenderCoords = null;
            this.lastSecondaryRenderDistance = this.primaryRenderDistance;
        }
        this.lastPlayerCoord = new class_1923(RenderSpec.minecraft.field_1724.method_31476().field_9181, RenderSpec.minecraft.field_1724.method_31476().field_9180);
        if (this.primaryRenderCoords == null || this.primaryRenderCoords.isEmpty()) {
            List primaryOffsets = this.offsets.get((Object)this.primaryRenderDistance);
            this.primaryRenderCoords = new ArrayList(primaryOffsets.size());
            for (Offset offset : primaryOffsets) {
                class_1923 primaryCoord = offset.from(this.lastPlayerCoord);
                this.primaryRenderCoords.add(primaryCoord);
                dataCache.getChunkMD(primaryCoord);
            }
        }
        if (this.maxSecondaryRenderDistance == this.primaryRenderDistance) {
            return new ArrayList<class_1923>(this.primaryRenderCoords);
        }
        if (this.lastSecondaryRenderDistance == this.maxSecondaryRenderDistance) {
            this.lastSecondaryRenderDistance = this.primaryRenderDistance;
        }
        ++this.lastSecondaryRenderDistance;
        List secondaryOffsets = this.offsets.get((Object)this.lastSecondaryRenderDistance);
        ArrayList<class_1923> renderCoords = new ArrayList<class_1923>(this.primaryRenderCoords.size() + secondaryOffsets.size());
        for (Offset offset : secondaryOffsets) {
            class_1923 secondaryCoord = offset.from(this.lastPlayerCoord);
            renderCoords.add(secondaryCoord);
            dataCache.getChunkMD(secondaryCoord);
        }
        renderCoords.addAll(0, this.primaryRenderCoords);
        return renderCoords;
    }

    public Boolean isUnderground() {
        return this.mapType.isUnderground();
    }

    public Boolean isTopo() {
        return this.mapType.isTopo();
    }

    public Boolean getSurface() {
        return this.mapType.isSurface();
    }

    public int getPrimaryRenderDistance() {
        return this.primaryRenderDistance;
    }

    public int getMaxSecondaryRenderDistance() {
        return this.maxSecondaryRenderDistance;
    }

    public int getLastSecondaryRenderDistance() {
        return this.lastSecondaryRenderDistance;
    }

    public RevealShape getRevealShape() {
        return this.revealShape;
    }

    public int getLastSecondaryRenderSize() {
        if (this.primaryRenderDistance == this.maxSecondaryRenderDistance) {
            return 0;
        }
        return this.offsets == null ? 0 : this.offsets.get((Object)this.lastSecondaryRenderDistance).size();
    }

    public int getPrimaryRenderSize() {
        return this.offsets == null ? 0 : this.offsets.get((Object)this.primaryRenderDistance).size();
    }

    public void setLastTaskInfo(int chunks, long elapsedNs) {
        this.lastTaskChunks = chunks;
        this.lastTaskTime = TimeUnit.NANOSECONDS.toMillis(elapsedNs);
        this.lastTaskAvgChunkTime = (double)(elapsedNs / (long)Math.max(1, chunks)) / 1000000.0;
    }

    public int getLastTaskChunks() {
        return this.lastTaskChunks;
    }

    public void copyLastStatsFrom(RenderSpec other) {
        if (other != null) {
            this.lastTaskChunks = other.lastTaskChunks;
            this.lastTaskTime = other.lastTaskTime;
            this.lastTaskAvgChunkTime = other.lastTaskAvgChunkTime;
        }
    }

    public String getDebugStats() {
        Object debugString = this.isUnderground() != false ? "jm.common.renderstats_debug_cave" : (this.isTopo() != false ? "jm.common.renderstats_debug_topo" : "jm.common.renderstats_debug_surface");
        debugString = (String)debugString + "_simple";
        return Constants.getString((String)debugString, this.primaryRenderDistance, this.lastTaskChunks, this.lastTaskTime, decFormat.format(this.lastTaskAvgChunkTime));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderSpec that = (RenderSpec)o;
        if (this.maxSecondaryRenderDistance != that.maxSecondaryRenderDistance) {
            return false;
        }
        if (this.primaryRenderDistance != that.primaryRenderDistance) {
            return false;
        }
        if (this.revealShape != that.revealShape) {
            return false;
        }
        return this.mapType.equals(that.mapType);
    }

    public int hashCode() {
        int result = this.mapType.hashCode();
        result = 31 * result + this.primaryRenderDistance;
        result = 31 * result + this.maxSecondaryRenderDistance;
        result = 31 * result + this.revealShape.hashCode();
        return result;
    }

    static {
        minecraft = class_310.method_1551();
    }

    public static enum RevealShape implements KeyedEnum
    {
        Square("jm.minimap.shape_square"),
        Circle("jm.minimap.shape_circle");

        public final String key;

        private RevealShape(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return Constants.getString(this.key);
        }
    }

    private static class Offset {
        final int x;
        final int z;

        private Offset(int x, int z) {
            this.x = x;
            this.z = z;
        }

        class_1923 from(class_1923 coord) {
            return new class_1923(coord.field_9181 + this.x, coord.field_9180 + this.z);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Offset offset = (Offset)o;
            if (this.x != offset.x) {
                return false;
            }
            return this.z == offset.z;
        }

        public double distance() {
            return Math.sqrt(this.x * this.x + this.z * this.z);
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.z;
            return result;
        }
    }
}

