/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.classic4j.model;

import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CookieStore {
    private final Map<String, String> values;

    public CookieStore() {
        this.values = new HashMap<String, String>();
    }

    public CookieStore(Map<String, String> values) {
        this.values = values;
    }

    public Map<String, String> getMap() {
        return Collections.unmodifiableMap(this.values);
    }

    public void merge(CookieStore cookieStore) {
        this.values.putAll(cookieStore.getMap());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> entry : this.values.entrySet()) {
            if (i != 0) {
                builder.append(";");
            }
            builder.append(entry.getKey());
            builder.append("=");
            builder.append(entry.getValue());
            ++i;
        }
        return builder.toString();
    }

    public void mergeFromResponse(HttpResponse<?> response) {
        Optional<String> setCookieHeaderOptional = response.headers().firstValue("set-cookie");
        if (setCookieHeaderOptional.isEmpty()) {
            return;
        }
        String setCookieHeader = setCookieHeaderOptional.get();
        CookieStore store = CookieStore.parse(setCookieHeader);
        this.merge(store);
    }

    public HttpRequest.Builder appendCookies(HttpRequest.Builder builder) {
        builder.header("Cookie", this.toString());
        return builder;
    }

    public static CookieStore parse(String value) {
        char[] characters = value.toCharArray();
        StringBuilder currentKey = new StringBuilder();
        StringBuilder currentValue = new StringBuilder();
        boolean key = true;
        HashMap<String, String> values = new HashMap<String, String>();
        for (char character : characters) {
            if (character == '=' && key) {
                currentValue = new StringBuilder();
                key = false;
                continue;
            }
            if (character == ';' && !key) {
                key = true;
                values.put(currentKey.toString(), currentValue.toString());
                continue;
            }
            if (key) {
                currentKey.append(character);
                continue;
            }
            currentValue.append(character);
        }
        return new CookieStore(values);
    }
}

