/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.classic4j.model.betacraft;

import de.florianmichael.classic4j.model.betacraft.BCServerInfo;
import de.florianmichael.classic4j.model.betacraft.BCVersion;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public record BCServerList(List<BCServerInfo> servers) {
    private final List<BCServerInfo> servers;

    public static BCServerList fromDocument(Document document) {
        LinkedList<BCServerInfo> servers = new LinkedList<BCServerInfo>();
        Elements serverElements = document.getElementsByClass("online");
        for (Element serverElement : serverElements) {
            int playerLimit;
            int playerCount;
            String playerCountActualContent;
            String[] splitPlayerCount;
            int port;
            String hostAndPort;
            int portColonIndex;
            String substringedUrl;
            String[] urlParts;
            String joinUrl = serverElement.attr("href");
            if (joinUrl.length() < 7 || (urlParts = (substringedUrl = joinUrl.substring(7)).split("/")).length != 4 || (portColonIndex = (hostAndPort = urlParts[0]).lastIndexOf(":")) == -1) continue;
            String portStr = hostAndPort.substring(Math.min(portColonIndex + 1, hostAndPort.length() - 1));
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException ignored) {
                continue;
            }
            String host = hostAndPort.substring(0, portColonIndex).replace(":" + port, "");
            String versionIdentifier = urlParts[3];
            BCVersion version = BCVersion.fromString(versionIdentifier);
            String rawNameStr = serverElement.text();
            int firstIndexOfClosingSquareBracket = rawNameStr.indexOf("]");
            if (firstIndexOfClosingSquareBracket == -1) continue;
            String halfParsedNameStr = rawNameStr.substring(Math.min(firstIndexOfClosingSquareBracket + 2, rawNameStr.length() - 1));
            boolean onlineMode = halfParsedNameStr.endsWith("[Online Mode]");
            String parsedNameStr = onlineMode ? halfParsedNameStr.replace("[Online Mode]", "") : halfParsedNameStr;
            Element playerCountElement = serverElement.nextElementSibling();
            if (playerCountElement == null) continue;
            String playerCountContent = playerCountElement.text();
            int indexOfOpeningBracket = playerCountContent.indexOf("(");
            int indexOfClosingBracket = playerCountContent.indexOf(")");
            if (indexOfOpeningBracket == -1 || indexOfClosingBracket == -1 || (splitPlayerCount = (playerCountActualContent = playerCountContent.substring(indexOfOpeningBracket + 1, indexOfClosingBracket).replace(" ", "")).split("/")).length != 2) continue;
            try {
                playerCount = Integer.parseInt(splitPlayerCount[0]);
                playerLimit = Integer.parseInt(splitPlayerCount[1]);
            }
            catch (NumberFormatException ignored) {
                continue;
            }
            BCServerInfo server = new BCServerInfo(parsedNameStr, playerCount, playerLimit, host, port, version, onlineMode, joinUrl, versionIdentifier);
            servers.add(server);
        }
        return new BCServerList(servers);
    }

    public List<BCServerInfo> servers() {
        return Collections.unmodifiableList(this.servers);
    }

    public List<BCServerInfo> serversOfVersion(BCVersion version) {
        List<BCServerInfo> serverListCopy = this.servers();
        return serverListCopy.stream().filter(s -> s.version().equals((Object)version)).toList();
    }

    public List<BCServerInfo> serversWithOnlineMode(boolean on) {
        return this.servers().stream().filter(s -> s.onlineMode() == on).toList();
    }

    public List<BCServerInfo> withGameVersion(String gameVersion) {
        return this.servers().stream().filter(s -> s.gameVersion().equals(gameVersion)).toList();
    }
}

