/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.classic4j.model.betacraft;

import java.util.Arrays;

public enum BCVersion {
    RELEASE(new String[]{"r", "1"}),
    CLASSIC(new String[]{"c"}),
    INDEV(new String[]{"mp-in-", "in-", "indev"}),
    INFDEV(new String[]{"infdev"}),
    ALPHA(new String[]{"a", "nsss"}),
    BETA(new String[]{"b"}),
    UNKNOWN(new String[0]);

    final String[] versionPrefixes;

    private BCVersion(String[] versionPrefixes) {
        this.versionPrefixes = versionPrefixes;
    }

    public String[] versionPrefixes() {
        String[] copy = new String[this.versionPrefixes.length];
        System.arraycopy(this.versionPrefixes, 0, copy, 0, this.versionPrefixes.length);
        return copy;
    }

    public static BCVersion fromString(String versionString) {
        String lowercaseVersionString = versionString.toLowerCase();
        return Arrays.stream(BCVersion.values()).filter(v -> Arrays.stream(v.versionPrefixes).anyMatch(lowercaseVersionString::startsWith)).findFirst().orElse(UNKNOWN);
    }

    public String toString() {
        return "Version{versionPrefixes=" + Arrays.toString(this.versionPrefixes) + "}";
    }
}

