/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.classic4j.request.classicube.auth;

import de.florianmichael.classic4j.ClassiCubeHandler;
import de.florianmichael.classic4j.model.classicube.highlevel.CCAccount;
import de.florianmichael.classic4j.model.classicube.highlevel.CCAuthenticationData;
import de.florianmichael.classic4j.request.classicube.auth.base.CCAuthenticationResponse;
import de.florianmichael.classic4j.util.Pair;
import de.florianmichael.classic4j.util.WebRequests;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;

public class CCAuthenticationLoginRequest {
    public static CompletableFuture<CCAuthenticationResponse> send(CCAccount account, CCAuthenticationResponse previousResponse, String loginCode) {
        return CompletableFuture.supplyAsync(() -> {
            CCAuthenticationData authenticationData = new CCAuthenticationData(account.username(), account.password(), previousResponse.token, loginCode);
            String requestBody = WebRequests.createRequestBody(new Pair<String, String>("username", authenticationData.username()), new Pair<String, String>("password", authenticationData.password()), new Pair<String, String>("token", authenticationData.previousToken()), new Pair<String, String>("login_code", authenticationData.loginCode()));
            HttpRequest request = WebRequests.buildWithCookies(account.cookieStore, HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(requestBody)).uri(ClassiCubeHandler.AUTHENTICATION_URI).header("content-type", "application/x-www-form-urlencoded"));
            HttpResponse<String> response = WebRequests.HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).join();
            WebRequests.updateCookies(account.cookieStore, response);
            String responseBody = response.body();
            return CCAuthenticationResponse.fromJson(responseBody);
        });
    }
}

