/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.classic4j.request.classicube.auth.base;

import de.florianmichael.classic4j.ClassiCubeHandler;
import de.florianmichael.classic4j.model.classicube.highlevel.CCError;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public class CCAuthenticationResponse {
    public final String token;
    public final String username;
    public final boolean authenticated;
    public final Set<String> errors;

    public CCAuthenticationResponse(String token, String username, boolean authenticated, Set<String> errors) {
        this.token = token;
        this.username = username;
        this.authenticated = authenticated;
        this.errors = errors;
    }

    public boolean shouldError() {
        return this.errors.size() > 0;
    }

    public String getErrorDisplay() {
        StringBuilder builder = new StringBuilder();
        for (String error : this.errors) {
            builder.append(CCError.valueOf((String)error.toUpperCase()).description).append("\n");
        }
        return builder.toString().trim();
    }

    public Set<CCError> errors() {
        return this.errors.stream().map(s -> CCError.valueOf(s.toUpperCase(Locale.ROOT))).collect(Collectors.toSet());
    }

    public boolean mfaRequired() {
        return this.errors().stream().anyMatch(e -> e == CCError.LOGIN_CODE);
    }

    public static CCAuthenticationResponse fromJson(String json) {
        return (CCAuthenticationResponse)ClassiCubeHandler.GSON.fromJson(json, CCAuthenticationResponse.class);
    }
}

