/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.classic4j.util;

import de.florianmichael.classic4j.model.CookieStore;
import de.florianmichael.classic4j.util.Pair;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;

public class WebRequests {
    public static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();

    @SafeVarargs
    public static String createRequestBody(Pair<String, String> ... parameters) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < parameters.length; ++i) {
            Pair<String, String> parameter = parameters[i];
            if (parameter.key() == null || parameter.value() == null) continue;
            builder.append(parameter.key()).append("=").append(URLEncoder.encode(parameter.value(), StandardCharsets.UTF_8));
            if (i == parameters.length - 1) continue;
            builder.append("&");
        }
        return builder.toString();
    }

    public static HttpRequest buildWithCookies(CookieStore cookieStore, HttpRequest.Builder builder) {
        return cookieStore.appendCookies(builder).build();
    }

    public static void updateCookies(CookieStore cookieStore, HttpResponse<?> response) {
        cookieStore.mergeFromResponse(response);
    }
}

