/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.base.settings;

import com.google.gson.JsonObject;
import de.florianmichael.viafabricplus.base.FileSaver;
import de.florianmichael.viafabricplus.base.event.InitializeSettingsCallback;
import de.florianmichael.viafabricplus.base.settings.base.AbstractSetting;
import de.florianmichael.viafabricplus.base.settings.base.SettingGroup;
import de.florianmichael.viafabricplus.base.settings.groups.AuthenticationSettings;
import de.florianmichael.viafabricplus.base.settings.groups.DebugSettings;
import de.florianmichael.viafabricplus.base.settings.groups.ExperimentalSettings;
import de.florianmichael.viafabricplus.base.settings.groups.GeneralSettings;
import de.florianmichael.viafabricplus.base.settings.groups.VisualSettings;
import de.florianmichael.viafabricplus.protocolhack.ProtocolHack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.raphimc.vialoader.util.VersionEnum;

public class SettingsSystem
extends FileSaver {
    private final List<SettingGroup> groups = new ArrayList<SettingGroup>();

    public SettingsSystem() {
        super("settings.json");
    }

    @Override
    public void init() {
        this.addGroup(GeneralSettings.INSTANCE, ExperimentalSettings.INSTANCE, AuthenticationSettings.INSTANCE, VisualSettings.INSTANCE, DebugSettings.INSTANCE);
        ((InitializeSettingsCallback)InitializeSettingsCallback.EVENT.invoker()).onInitializeSettings();
        super.init();
    }

    @Override
    public void write(JsonObject object) {
        object.addProperty("protocol", (Number)ProtocolHack.getTargetVersion().getVersion());
        for (SettingGroup group : this.groups) {
            for (AbstractSetting<?> setting : group.getSettings()) {
                setting.write(object);
            }
        }
    }

    @Override
    public void read(JsonObject object) {
        VersionEnum protocolVersion;
        if (object.has("protocol") && (protocolVersion = VersionEnum.fromProtocolId(object.get("protocol").getAsInt())) != null) {
            ProtocolHack.setTargetVersion(protocolVersion);
        }
        for (SettingGroup group : this.groups) {
            for (AbstractSetting<?> setting : group.getSettings()) {
                setting.read(object);
            }
        }
    }

    public void addGroup(SettingGroup ... groups) {
        Collections.addAll(this.groups, groups);
    }

    public List<SettingGroup> getGroups() {
        return this.groups;
    }
}

