/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.definition.bedrock;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.florianmichael.viafabricplus.ViaFabricPlus;
import de.florianmichael.viafabricplus.base.FileSaver;
import net.raphimc.mcauth.MinecraftAuth;
import net.raphimc.mcauth.step.bedrock.StepMCChain;
import net.raphimc.mcauth.step.bedrock.playfab.StepPlayFabToken;
import net.raphimc.mcauth.util.MicrosoftConstants;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;

public class BedrockAccountHandler
extends FileSaver {
    public static BedrockAccountHandler INSTANCE;
    private StepMCChain.MCChain mcChain;
    private StepPlayFabToken.PlayFabToken playFabToken;

    public static void create() {
        INSTANCE = new BedrockAccountHandler();
        INSTANCE.init();
    }

    public BedrockAccountHandler() {
        super("bedrock.account");
    }

    @Override
    public void write(JsonObject object) {
        if (this.mcChain == null) {
            return;
        }
        object.add("mc-chain", (JsonElement)this.mcChain.toJson());
        object.add("play-fab-token", (JsonElement)this.playFabToken.toJson());
    }

    @Override
    public void read(JsonObject object) {
        try {
            this.mcChain = MinecraftAuth.BEDROCK_DEVICE_CODE_LOGIN.fromJson(object.get("mc-chain").getAsJsonObject());
            try (CloseableHttpClient httpClient = MicrosoftConstants.createHttpClient();){
                this.mcChain = MinecraftAuth.BEDROCK_DEVICE_CODE_LOGIN.refresh(httpClient, this.mcChain);
            }
            this.playFabToken = MinecraftAuth.BEDROCK_PLAY_FAB_TOKEN.fromJson(object.get("play-fab-token").getAsJsonObject());
            httpClient = MicrosoftConstants.createHttpClient();
            try {
                this.playFabToken = MinecraftAuth.BEDROCK_PLAY_FAB_TOKEN.refresh((HttpClient)httpClient, this.playFabToken);
            }
            finally {
                if (httpClient != null) {
                    httpClient.close();
                }
            }
        }
        catch (Exception e) {
            ViaFabricPlus.LOGGER.warn("No Bedrock account could be found");
        }
    }

    public void setAccount(StepMCChain.MCChain mcChain, StepPlayFabToken.PlayFabToken playFabToken) {
        this.mcChain = mcChain;
        this.playFabToken = playFabToken;
    }

    public StepMCChain.MCChain getMcChain() {
        return this.mcChain;
    }

    public StepPlayFabToken.PlayFabToken getPlayFabToken() {
        return this.playFabToken;
    }
}

