/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.definition.c0_30.protocol;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.protocols.protocol1_17to1_16_4.types.Chunk1_17Type;
import de.florianmichael.viafabricplus.protocolhack.ProtocolHack;
import java.util.ArrayList;
import java.util.BitSet;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.model.ClassicLevel;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.providers.ClassicWorldHeightProvider;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.storage.ClassicLevelStorage;
import net.raphimc.vialoader.util.VersionEnum;

public class ClassicWorldHeightInjection {
    public static PacketHandler handleJoinGame(PacketHandler parentHandler) {
        return wrapper -> {
            parentHandler.handle(wrapper);
            if (wrapper.isCancelled()) {
                return;
            }
            if (ProtocolHack.getTargetVersion(wrapper.user().getChannel()).isOlderThanOrEqualTo(VersionEnum.c0_28toc0_30)) {
                for (Tag dimension : (ListTag)((CompoundTag)wrapper.get(Type.NBT, 0).get("minecraft:dimension_type")).get("value")) {
                    ClassicWorldHeightInjection.changeDimensionTagHeight(wrapper.user(), (CompoundTag)((CompoundTag)dimension).get("element"));
                }
                ClassicWorldHeightInjection.changeDimensionTagHeight(wrapper.user(), wrapper.get(Type.NBT, 1));
            }
        };
    }

    public static PacketHandler handleRespawn(PacketHandler parentHandler) {
        return wrapper -> {
            parentHandler.handle(wrapper);
            if (wrapper.isCancelled()) {
                return;
            }
            if (ProtocolHack.getTargetVersion(wrapper.user().getChannel()).isOlderThanOrEqualTo(VersionEnum.c0_28toc0_30)) {
                ClassicWorldHeightInjection.changeDimensionTagHeight(wrapper.user(), wrapper.get(Type.NBT, 0));
            }
        };
    }

    public static PacketHandler handleChunkData(PacketHandler parentHandler) {
        return wrapper -> {
            parentHandler.handle(wrapper);
            if (wrapper.isCancelled()) {
                return;
            }
            if (ProtocolHack.getTargetVersion(wrapper.user().getChannel()).isOlderThanOrEqualTo(VersionEnum.c0_28toc0_30)) {
                wrapper.resetReader();
                Chunk chunk = wrapper.read(new Chunk1_17Type(16));
                wrapper.write(new Chunk1_17Type(chunk.getSections().length), chunk);
                ClassicWorldHeightProvider heightProvider = Via.getManager().getProviders().get(ClassicWorldHeightProvider.class);
                if (chunk.getSections().length < heightProvider.getMaxChunkSectionCount(wrapper.user())) {
                    ChunkSection[] newArray = new ChunkSection[heightProvider.getMaxChunkSectionCount(wrapper.user())];
                    System.arraycopy(chunk.getSections(), 0, newArray, 0, chunk.getSections().length);
                    chunk.setSections(newArray);
                }
                BitSet chunkMask = new BitSet();
                for (int i = 0; i < chunk.getSections().length; ++i) {
                    if (chunk.getSections()[i] == null) continue;
                    chunkMask.set(i);
                }
                chunk.setChunkMask(chunkMask);
                int[] newBiomeData = new int[chunk.getSections().length * 4 * 4 * 4];
                System.arraycopy(chunk.getBiomeData(), 0, newBiomeData, 0, chunk.getBiomeData().length);
                for (int i = 64; i < chunk.getSections().length * 4; ++i) {
                    System.arraycopy(chunk.getBiomeData(), chunk.getBiomeData().length - 16, newBiomeData, i * 16, 16);
                }
                chunk.setBiomeData(newBiomeData);
                chunk.setHeightMap(new CompoundTag());
            }
        };
    }

    public static PacketHandler handleUpdateLight(PacketHandler parentHandler) {
        PacketHandlers classicLightHandler = new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.VAR_INT);
                this.map(Type.VAR_INT);
                this.map(Type.BOOLEAN);
                this.handler(wrapper -> {
                    short i;
                    wrapper.read(Type.VAR_INT);
                    wrapper.read(Type.VAR_INT);
                    int emptySkyLightMask = wrapper.read(Type.VAR_INT);
                    int emptyBlockLightMask = wrapper.read(Type.VAR_INT);
                    ClassicLevel level = wrapper.user().get(ClassicLevelStorage.class).getClassicLevel();
                    ClassicWorldHeightProvider heightProvider = Via.getManager().getProviders().get(ClassicWorldHeightProvider.class);
                    short sectionYCount = level.getSizeY() >> 4;
                    if (level.getSizeY() % 16 != 0) {
                        ++sectionYCount;
                    }
                    if (sectionYCount > heightProvider.getMaxChunkSectionCount(wrapper.user())) {
                        sectionYCount = heightProvider.getMaxChunkSectionCount(wrapper.user());
                    }
                    ArrayList<byte[]> lightArrays = new ArrayList<byte[]>();
                    while (wrapper.isReadable(Type.BYTE_ARRAY_PRIMITIVE, 0)) {
                        lightArrays.add(wrapper.read(Type.BYTE_ARRAY_PRIMITIVE));
                    }
                    short skyLightCount = 16;
                    short blockLightCount = sectionYCount;
                    if (lightArrays.size() == 18) {
                        blockLightCount = 0;
                    } else if (lightArrays.size() != 16 + sectionYCount + 2 && lightArrays.size() == sectionYCount + sectionYCount + 2) {
                        skyLightCount = sectionYCount;
                    }
                    BitSet skyLightMask = new BitSet();
                    BitSet blockLightMask = new BitSet();
                    skyLightMask.set(0, skyLightCount += 2);
                    blockLightMask.set(0, blockLightCount);
                    wrapper.write(Type.LONG_ARRAY_PRIMITIVE, skyLightMask.toLongArray());
                    wrapper.write(Type.LONG_ARRAY_PRIMITIVE, blockLightMask.toLongArray());
                    wrapper.write(Type.LONG_ARRAY_PRIMITIVE, new long[emptySkyLightMask]);
                    wrapper.write(Type.LONG_ARRAY_PRIMITIVE, new long[emptyBlockLightMask]);
                    wrapper.write(Type.VAR_INT, Integer.valueOf(skyLightCount));
                    for (i = 0; i < skyLightCount; ++i) {
                        wrapper.write(Type.BYTE_ARRAY_PRIMITIVE, (byte[])lightArrays.remove(0));
                    }
                    wrapper.write(Type.VAR_INT, Integer.valueOf(blockLightCount));
                    for (i = 0; i < blockLightCount; ++i) {
                        wrapper.write(Type.BYTE_ARRAY_PRIMITIVE, (byte[])lightArrays.remove(0));
                    }
                });
            }
        };
        return wrapper -> {
            if (ProtocolHack.getTargetVersion(wrapper.user().getChannel()).isOlderThanOrEqualTo(VersionEnum.c0_28toc0_30)) {
                classicLightHandler.handle(wrapper);
            } else {
                parentHandler.handle(wrapper);
            }
        };
    }

    private static void changeDimensionTagHeight(UserConnection user, CompoundTag tag) {
        tag.put("height", new IntTag(Via.getManager().getProviders().get(ClassicWorldHeightProvider.class).getMaxChunkSectionCount(user) << 4));
    }
}

