/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.definition.v1_19_2;

import de.florianmichael.viafabricplus.definition.v1_19_2.model.SignatureUpdatableModel;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;

public interface MessageSigner {
    public byte[] sign(SignatureUpdatableModel var1);

    public static MessageSigner create(PrivateKey privateKey, String algorithm) {
        return signer -> {
            try {
                Signature signature = Signature.getInstance(algorithm);
                signature.initSign(privateKey);
                signer.update(data -> {
                    try {
                        signature.update(data);
                    }
                    catch (SignatureException e) {
                        throw new RuntimeException(e);
                    }
                });
                return signature.sign();
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                throw new IllegalStateException("Failed to sign message", e);
            }
        };
    }
}

