/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.definition.v1_19_2.model;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.viaversion.viaversion.api.minecraft.PlayerMessageSignature;
import de.florianmichael.viafabricplus.definition.v1_19_2.model.MessageMetadataModel;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.Instant;

public class MessageBodyModel {
    private final MessageMetadataModel messageMetadata;
    private final PlayerMessageSignature[] lastSeenMessages;

    public MessageBodyModel(MessageMetadataModel messageMetadata, PlayerMessageSignature[] lastSeenMessages) {
        this.messageMetadata = messageMetadata;
        this.lastSeenMessages = lastSeenMessages;
    }

    public void writeLastSeenMessage(DataOutput dataOutput) {
        for (PlayerMessageSignature seenMessage : this.lastSeenMessages) {
            try {
                dataOutput.writeByte(70);
                dataOutput.writeLong(seenMessage.uuid().getMostSignificantBits());
                dataOutput.writeLong(seenMessage.uuid().getLeastSignificantBits());
                dataOutput.write(seenMessage.signatureBytes());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public byte[] digestBytes() {
        HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha256(), OutputStream.nullOutputStream());
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)hashingOutputStream);
        try {
            dataOutputStream.writeLong(this.messageMetadata.salt());
            dataOutputStream.writeLong(Instant.ofEpochMilli(this.messageMetadata.timestamp()).getEpochSecond());
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)dataOutputStream, StandardCharsets.UTF_8);
            outputStreamWriter.write(this.messageMetadata.plain());
            outputStreamWriter.flush();
            dataOutputStream.write(70);
            this.writeLastSeenMessage(dataOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hashingOutputStream.hash().asBytes();
    }
}

