/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.information.impl;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import de.florianmichael.viafabricplus.definition.bedrock.ModelFormats;
import de.florianmichael.viafabricplus.definition.bedrock.storage.JoinGameStorage;
import de.florianmichael.viafabricplus.information.AbstractInformationGroup;
import de.florianmichael.viafabricplus.protocolhack.provider.viabedrock.ViaFabricPlusBlobCacheProvider;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lenni0451.reflect.stream.RStream;
import net.lenni0451.reflect.stream.field.FieldStream;
import net.raphimc.viabedrock.protocol.providers.BlobCacheProvider;
import net.raphimc.viabedrock.protocol.storage.BlobCache;
import net.raphimc.viabedrock.protocol.storage.ChunkTracker;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.vialoader.util.VersionEnum;
import net.raphimc.vialoader.util.VersionRange;

public class BedrockInformation
extends AbstractInformationGroup {
    public BedrockInformation() {
        super(VersionRange.singleton(VersionEnum.bedrockLatest));
    }

    @Override
    public void applyInformation(UserConnection userConnection, List<String> output) {
        GameSessionStorage gameSessionStorage;
        JoinGameStorage joinGameStorage;
        EntityTracker entityTracker;
        ChunkTracker chunkTracker;
        ViaFabricPlusBlobCacheProvider blobCache = (ViaFabricPlusBlobCacheProvider)Via.getManager().getProviders().get(BlobCacheProvider.class);
        if (blobCache != null) {
            long totalSize = blobCache.getSize();
            int blobCount = blobCache.getBlobs().size();
            int pendingCount = ((Map)RStream.of(userConnection.get(BlobCache.class)).fields().by("pending").get()).size();
            if (totalSize != 0L || blobCount != 0 || pendingCount != 0) {
                output.add("Blob Cache:");
            }
            if (totalSize != 0L) {
                output.add("Total size: " + this.formatBytes(totalSize));
            }
            if (blobCount != 0) {
                output.add("Blob count: " + blobCount);
            }
            if (pendingCount != 0) {
                output.add("Pending count: " + pendingCount);
            }
        }
        if ((chunkTracker = userConnection.get(ChunkTracker.class)) != null) {
            FieldStream fields = RStream.of(chunkTracker).fields();
            int subChunkRequests = ((Set)fields.by("subChunkRequests").get()).size();
            int pendingSubChunks = ((Set)fields.by("pendingSubChunks").get()).size();
            int chunks = ((Map)fields.by("chunks").get()).size();
            if (subChunkRequests != 0 || pendingSubChunks != 0 || chunks != 0) {
                if (!output.isEmpty()) {
                    output.add("");
                }
                output.add("Chunk Tracker:");
            }
            if (subChunkRequests != 0) {
                output.add("Sub-chunk requests: " + subChunkRequests);
            }
            if (pendingSubChunks != 0) {
                output.add("Pending Sub-chunks: " + pendingSubChunks);
            }
            if (chunks != 0) {
                output.add("Chunks: " + chunks);
            }
        }
        if ((entityTracker = userConnection.get(EntityTracker.class)) != null) {
            int entities;
            if (!output.isEmpty()) {
                output.add("");
            }
            if ((entities = ((Map)RStream.of(entityTracker).fields().by("entities").get()).size()) != 0) {
                output.add("Entity Tracker: " + entities);
            }
        }
        if (!(joinGameStorage = userConnection.get(JoinGameStorage.class)).getLevelId().isEmpty() || joinGameStorage.getSeed() != 0L || joinGameStorage.getEnchantmentSeed() != 0L) {
            if (!output.isEmpty()) {
                output.add("");
            }
            output.add("Join Game:");
        }
        if (joinGameStorage.getSeed() != 0L) {
            output.add("World Seed: " + joinGameStorage.getSeed());
        }
        if (!joinGameStorage.getLevelId().isEmpty()) {
            output.add("Level Id: " + joinGameStorage.getLevelId());
        }
        if (joinGameStorage.getEnchantmentSeed() != 0L) {
            output.add("Enchantment Seed: " + joinGameStorage.getEnchantmentSeed());
        }
        if ((gameSessionStorage = userConnection.get(GameSessionStorage.class)) != null) {
            output.add("Movement mode: " + ModelFormats.formatMovementMode(gameSessionStorage.getMovementMode()));
        }
    }
}

