/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.injection.mixin.base;

import de.florianmichael.viafabricplus.base.event.ChangeProtocolVersionCallback;
import de.florianmichael.viafabricplus.base.event.DisconnectConnectionCallback;
import de.florianmichael.viafabricplus.injection.access.IClientConnection;
import de.florianmichael.viafabricplus.protocolhack.ProtocolHack;
import de.florianmichael.viafabricplus.protocolhack.netty.viabedrock.RakNetClientConnection;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import net.minecraft.class_2528;
import net.minecraft.class_2529;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3528;
import net.raphimc.viabedrock.netty.AesEncryption;
import net.raphimc.viabedrock.netty.SnappyCompression;
import net.raphimc.viabedrock.netty.ZLibCompression;
import net.raphimc.vialoader.netty.CompressionReorderEvent;
import net.raphimc.vialoader.util.VersionEnum;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_2535.class})
public abstract class MixinClientConnection
extends SimpleChannelInboundHandler<class_2596<?>>
implements IClientConnection {
    @Shadow
    private Channel field_11651;
    @Shadow
    private boolean field_11647;
    @Unique
    private Cipher viafabricplus_decryptionCipher;
    @Unique
    private boolean viafabricplus_compressionEnabled = false;
    @Unique
    private InetSocketAddress viafabricplus_capturedAddress;

    @Shadow
    public abstract void channelActive(ChannelHandlerContext var1) throws Exception;

    @Inject(method={"setCompressionThreshold"}, at={@At(value="RETURN")})
    private void reorderCompression(int compressionThreshold, boolean rejectBad, CallbackInfo ci) {
        this.field_11651.pipeline().fireUserEventTriggered((Object)CompressionReorderEvent.INSTANCE);
    }

    @Inject(method={"setupEncryption"}, at={@At(value="HEAD")}, cancellable=true)
    private void storeEncryptionCiphers(Cipher decryptionCipher, Cipher encryptionCipher, CallbackInfo ci) {
        if (ProtocolHack.getTargetVersion(this.field_11651).isOlderThanOrEqualTo(VersionEnum.r1_6_4)) {
            ci.cancel();
            this.viafabricplus_decryptionCipher = decryptionCipher;
            this.viafabricplus_setupPreNettyEncryption(encryptionCipher);
        }
    }

    @Inject(method={"connect(Ljava/net/InetSocketAddress;ZLnet/minecraft/network/ClientConnection;)Lio/netty/channel/ChannelFuture;"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Lazy;get()Ljava/lang/Object;", shift=At.Shift.BEFORE)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void captureAddress(InetSocketAddress address, boolean useEpoll, class_2535 connection, CallbackInfoReturnable<ChannelFuture> cir, Class class_, class_3528 lazy) {
        ((IClientConnection)connection).viafabricplus_captureAddress(address);
        if (ProtocolHack.getTargetVersion(address) == VersionEnum.bedrockLatest) {
            cir.setReturnValue((Object)RakNetClientConnection.connectRakNet(connection, address, lazy, class_));
        }
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        if (RakNetClientConnection.getRakNetPingSessions().contains(this.viafabricplus_capturedAddress)) {
            this.channelActive(ctx);
            RakNetClientConnection.getRakNetPingSessions().remove(this.viafabricplus_capturedAddress);
        }
    }

    @Inject(method={"disconnect"}, at={@At(value="RETURN")})
    public void resetStorages(class_2561 disconnectReason, CallbackInfo ci) {
        ((ChangeProtocolVersionCallback)ChangeProtocolVersionCallback.EVENT.invoker()).onChangeProtocolVersion(ProtocolHack.getTargetVersion());
        ((DisconnectConnectionCallback)DisconnectConnectionCallback.EVENT.invoker()).onDisconnect();
    }

    @Unique
    public void viafabricplus_setupPreNettyEncryption(Cipher encryptionCipher) {
        this.field_11647 = true;
        this.field_11651.pipeline().addBefore("vialegacy-pre-netty-length-remover", "encrypt", (ChannelHandler)new class_2529(encryptionCipher));
    }

    @Override
    public void viafabricplus_setupPreNettyDecryption() {
        this.field_11647 = true;
        this.field_11651.pipeline().addBefore("vialegacy-pre-netty-length-prepender", "decrypt", (ChannelHandler)new class_2528(this.viafabricplus_decryptionCipher));
    }

    @Override
    public InetSocketAddress viafabricplus_capturedAddress() {
        return this.viafabricplus_capturedAddress;
    }

    @Override
    public void viafabricplus_captureAddress(InetSocketAddress socketAddress) {
        this.viafabricplus_capturedAddress = socketAddress;
    }

    @Override
    public void viafabricplus_enableZLibCompression() {
        if (this.viafabricplus_compressionEnabled) {
            throw new IllegalStateException("Compression is already enabled");
        }
        this.viafabricplus_compressionEnabled = true;
        this.field_11651.pipeline().addBefore("splitter", "viabedrock-compression", (ChannelHandler)new ZLibCompression());
    }

    @Override
    public void viafabricplus_enableSnappyCompression() {
        if (this.viafabricplus_compressionEnabled) {
            throw new IllegalStateException("Compression is already enabled");
        }
        this.viafabricplus_compressionEnabled = true;
        this.field_11651.pipeline().addBefore("splitter", "viabedrock-compression", (ChannelHandler)new SnappyCompression());
    }

    @Override
    public void viafabricplus_enableAesGcmEncryption(SecretKey secretKey) throws InvalidAlgorithmParameterException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        if (this.field_11647) {
            throw new IllegalStateException("Encryption is already enabled");
        }
        this.field_11647 = true;
        this.field_11651.pipeline().addAfter("viabedrock-frame-encapsulation", "viabedrock-encryption", (ChannelHandler)new AesEncryption(secretKey));
    }
}

