/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.injection.mixin.fixes.minecraft;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import de.florianmichael.viafabricplus.mappings.PackFormatsMappings;
import de.florianmichael.viafabricplus.protocolhack.ProtocolHack;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1066;
import net.minecraft.class_6489;
import net.raphimc.vialoader.util.VersionEnum;
import org.apache.commons.codec.digest.DigestUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1066.class})
public class MixinServerResourcePackProvider {
    @Unique
    private File viafabricplus_trackedFile;

    @Redirect(method={"getDownloadHeaders"}, at=@At(value="INVOKE", target="Lnet/minecraft/SharedConstants;getGameVersion()Lnet/minecraft/GameVersion;"))
    private static class_6489 editHeaders() {
        return PackFormatsMappings.current();
    }

    @Inject(method={"getDownloadHeaders"}, at={@At(value="TAIL")}, cancellable=true)
    private static void removeHeaders(CallbackInfoReturnable<Map<String, String>> cir) {
        LinkedHashMap modifiableMap = new LinkedHashMap((Map)cir.getReturnValue());
        if (ProtocolHack.getTargetVersion().isOlderThan(VersionEnum.r1_14)) {
            modifiableMap.remove("X-Minecraft-Version-ID");
        }
        if (ProtocolHack.getTargetVersion().isOlderThan(VersionEnum.r1_13)) {
            modifiableMap.remove("X-Minecraft-Pack-Format");
            modifiableMap.remove("User-Agent");
        }
        cir.setReturnValue(modifiableMap);
    }

    @Inject(method={"verifyFile"}, at={@At(value="HEAD")})
    public void keepFile(String expectedSha1, File file, CallbackInfoReturnable<Boolean> cir) {
        this.viafabricplus_trackedFile = file;
    }

    @Redirect(method={"verifyFile"}, at=@At(value="INVOKE", target="Lcom/google/common/hash/HashCode;toString()Ljava/lang/String;", remap=false))
    public String revertHashAlgorithm(HashCode instance) {
        try {
            if (ProtocolHack.getTargetVersion().isOlderThanOrEqualTo(VersionEnum.r1_8)) {
                return Hashing.sha1().hashBytes(Files.toByteArray((File)this.viafabricplus_trackedFile)).toString();
            }
            if (ProtocolHack.getTargetVersion().isOlderThan(VersionEnum.r1_18tor1_18_1)) {
                return DigestUtils.sha1Hex(new FileInputStream(this.viafabricplus_trackedFile));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return instance.toString();
    }

    @Redirect(method={"verifyFile"}, at=@At(value="INVOKE", target="Ljava/lang/String;toLowerCase(Ljava/util/Locale;)Ljava/lang/String;"))
    public String disableIgnoreCase(String instance, Locale locale) {
        if (ProtocolHack.getTargetVersion().isOlderThanOrEqualTo(VersionEnum.r1_8)) {
            return instance;
        }
        return instance.toLowerCase(locale);
    }
}

