/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.injection.mixin.fixes.viaversion;

import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.api.protocol.version.VersionRange;
import com.viaversion.viaversion.util.Pair;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ProtocolVersion.class}, remap=false)
public abstract class MixinProtocolVersion {
    @Unique
    private static Map<String, Pair<String, VersionRange>> viafabricplus_remaps;

    @Inject(method={"<clinit>"}, at={@At(value="HEAD")})
    private static void initMaps(CallbackInfo ci) {
        viafabricplus_remaps = new HashMap<String, Pair<String, VersionRange>>();
        viafabricplus_remaps.put("1.7-1.7.5", new Pair<String, VersionRange>("1.7.2-1.7.5", new VersionRange("1.7", 2, 5)));
        viafabricplus_remaps.put("1.9.3/4", new Pair<String, Object>("1.9.3-1.9.4", null));
        viafabricplus_remaps.put("1.11.1/2", new Pair<String, Object>("1.11.1-1.11.2", null));
        viafabricplus_remaps.put("1.16.4/5", new Pair<String, Object>("1.16.4-1.16.5", null));
        viafabricplus_remaps.put("1.18/1.18.1", new Pair<String, Object>("1.18-1.18.1", null));
        viafabricplus_remaps.put("1.19.1/2", new Pair<String, Object>("1.19.1-1.19.2", null));
        viafabricplus_remaps.put("1.20/1.20.1", new Pair<String, Object>("1.20-1.20.1", null));
    }

    @Redirect(method={"<clinit>"}, at=@At(value="INVOKE", target="Lcom/viaversion/viaversion/api/protocol/version/ProtocolVersion;register(ILjava/lang/String;)Lcom/viaversion/viaversion/api/protocol/version/ProtocolVersion;"))
    private static ProtocolVersion unregisterAndRenameVersions(int version, String name) {
        Pair<String, VersionRange> remapEntry = viafabricplus_remaps.get(name);
        if (remapEntry != null && remapEntry.key() != null) {
            name = remapEntry.key();
        }
        return ProtocolVersion.register(version, name);
    }

    @Redirect(method={"<clinit>"}, at=@At(value="INVOKE", target="Lcom/viaversion/viaversion/api/protocol/version/ProtocolVersion;register(IILjava/lang/String;)Lcom/viaversion/viaversion/api/protocol/version/ProtocolVersion;"), require=0)
    private static ProtocolVersion unregisterAndRenameVersions(int version, int snapshotVersion, String name) {
        Pair<String, VersionRange> remapEntry = viafabricplus_remaps.get(name);
        if (remapEntry != null && remapEntry.key() != null) {
            name = remapEntry.key();
        }
        return ProtocolVersion.register(version, snapshotVersion, name);
    }

    @Redirect(method={"<clinit>"}, at=@At(value="INVOKE", target="Lcom/viaversion/viaversion/api/protocol/version/ProtocolVersion;register(ILjava/lang/String;Lcom/viaversion/viaversion/api/protocol/version/VersionRange;)Lcom/viaversion/viaversion/api/protocol/version/ProtocolVersion;"))
    private static ProtocolVersion unregisterAndRenameVersions(int version, String name, VersionRange versionRange) {
        Pair<String, VersionRange> remapEntry = viafabricplus_remaps.get(name);
        if (remapEntry != null) {
            if (remapEntry.key() != null) {
                name = remapEntry.key();
            }
            if (remapEntry.value() != null) {
                versionRange = remapEntry.value();
            }
        }
        return ProtocolVersion.register(version, name, versionRange);
    }
}

