/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.injection.mixin.fixes.viaversion.protocol1_19_3to1_19_1;

import com.google.common.primitives.Longs;
import com.viaversion.viabackwards.protocol.protocol1_19_1to1_19_3.storage.NonceStorage;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.protocol.AbstractProtocol;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.BitSetType;
import com.viaversion.viaversion.api.type.types.ByteArrayType;
import com.viaversion.viaversion.protocols.base.ClientboundLoginPackets;
import com.viaversion.viaversion.protocols.base.ServerboundLoginPackets;
import com.viaversion.viaversion.protocols.protocol1_19_1to1_19.ClientboundPackets1_19_1;
import com.viaversion.viaversion.protocols.protocol1_19_1to1_19.ServerboundPackets1_19_1;
import com.viaversion.viaversion.protocols.protocol1_19_3to1_19_1.ClientboundPackets1_19_3;
import com.viaversion.viaversion.protocols.protocol1_19_3to1_19_1.Protocol1_19_3To1_19_1;
import com.viaversion.viaversion.protocols.protocol1_19_3to1_19_1.ServerboundPackets1_19_3;
import com.viaversion.viaversion.protocols.protocol1_19_3to1_19_1.storage.ReceivedMessagesStorage;
import com.viaversion.viaversion.util.Pair;
import de.florianmichael.viafabricplus.definition.v1_19_0.provider.CommandArgumentsProvider;
import de.florianmichael.viafabricplus.definition.v1_19_2.model.MessageMetadataModel;
import de.florianmichael.viafabricplus.definition.v1_19_2.storage.ChatSession1_19_2;
import java.util.UUID;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Protocol1_19_3To1_19_1.class}, remap=false)
public class MixinProtocol1_19_3To1_19_1
extends AbstractProtocol<ClientboundPackets1_19_1, ClientboundPackets1_19_3, ServerboundPackets1_19_1, ServerboundPackets1_19_3> {
    @Unique
    private static final ByteArrayType.OptionalByteArrayType OPTIONAL_MESSAGE_SIGNATURE_BYTES_TYPE = new ByteArrayType.OptionalByteArrayType(256);
    @Unique
    private static final ByteArrayType MESSAGE_SIGNATURE_BYTES_TYPE = new ByteArrayType(256);
    @Unique
    private static final BitSetType ACKNOWLEDGED_BIT_SET_TYPE = new BitSetType(20);

    @Inject(method={"registerPackets"}, at={@At(value="RETURN")})
    public void fixKeys(CallbackInfo ci) {
        this.registerClientbound(State.LOGIN, ClientboundLoginPackets.HELLO.getId(), ClientboundLoginPackets.HELLO.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING);
                this.map(Type.BYTE_ARRAY_PRIMITIVE);
                this.map(Type.BYTE_ARRAY_PRIMITIVE);
                this.handler(wrapper -> wrapper.user().put(new NonceStorage(wrapper.get(Type.BYTE_ARRAY_PRIMITIVE, 1))));
            }
        }, true);
        this.registerServerbound(State.LOGIN, ServerboundLoginPackets.HELLO.getId(), ServerboundLoginPackets.HELLO.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING);
                this.handler(wrapper -> {
                    ChatSession1_19_2 chatSession1192 = wrapper.user().get(ChatSession1_19_2.class);
                    wrapper.write(Type.OPTIONAL_PROFILE_KEY, chatSession1192 != null ? chatSession1192.getProfileKey() : null);
                });
                this.map(Type.OPTIONAL_UUID);
            }
        }, true);
        this.registerServerbound(State.LOGIN, ServerboundLoginPackets.ENCRYPTION_KEY.getId(), ServerboundLoginPackets.ENCRYPTION_KEY.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.BYTE_ARRAY_PRIMITIVE);
                this.handler(wrapper -> {
                    ChatSession1_19_2 chatSession1192 = wrapper.user().get(ChatSession1_19_2.class);
                    byte[] encryptedNonce = wrapper.read(Type.BYTE_ARRAY_PRIMITIVE);
                    wrapper.write(Type.BOOLEAN, chatSession1192 == null);
                    if (chatSession1192 != null) {
                        long salt = ChatSession1_19_2.SECURE_RANDOM.nextLong();
                        byte[] signedNonce = chatSession1192.getSigner().sign(updater -> {
                            updater.update(wrapper.user().get(NonceStorage.class).nonce());
                            updater.update(Longs.toByteArray((long)salt));
                        });
                        wrapper.write(Type.LONG, salt);
                        wrapper.write(Type.BYTE_ARRAY_PRIMITIVE, signedNonce);
                    } else {
                        wrapper.write(Type.BYTE_ARRAY_PRIMITIVE, encryptedNonce);
                    }
                });
            }
        }, true);
        this.registerServerbound(ServerboundPackets1_19_3.CHAT_COMMAND, ServerboundPackets1_19_1.CHAT_COMMAND, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING);
                this.map(Type.LONG);
                this.map(Type.LONG);
                this.map(Type.VAR_INT);
                this.handler(wrapper -> {
                    int signatures = wrapper.get(Type.VAR_INT, 0);
                    ChatSession1_19_2 chatSession1192 = wrapper.user().get(ChatSession1_19_2.class);
                    CommandArgumentsProvider commandArgumentsProvider = Via.getManager().getProviders().get(CommandArgumentsProvider.class);
                    boolean signingEnabled = chatSession1192 != null && commandArgumentsProvider != null;
                    for (int i = 0; i < signatures; ++i) {
                        if (signingEnabled) {
                            wrapper.read(Type.STRING);
                            wrapper.read(MESSAGE_SIGNATURE_BYTES_TYPE);
                            continue;
                        }
                        wrapper.passthrough(Type.STRING);
                        wrapper.read(MESSAGE_SIGNATURE_BYTES_TYPE);
                        wrapper.write(Type.BYTE_ARRAY_PRIMITIVE, new byte[0]);
                    }
                    if (chatSession1192 != null) {
                        UUID sender = wrapper.user().getProtocolInfo().getUuid();
                        String command = wrapper.get(Type.STRING, 0);
                        long timestamp = wrapper.get(Type.LONG, 0);
                        long salt = wrapper.get(Type.LONG, 1);
                        ReceivedMessagesStorage messagesStorage = wrapper.user().get(ReceivedMessagesStorage.class);
                        for (Pair<String, String> argument : commandArgumentsProvider.getSignedArguments(command)) {
                            byte[] signature = chatSession1192.sign(sender, new MessageMetadataModel(argument.value(), timestamp, salt), messagesStorage.lastSignatures());
                            wrapper.write(Type.STRING, argument.key());
                            wrapper.write(Type.BYTE_ARRAY_PRIMITIVE, signature);
                        }
                    }
                    wrapper.write(Type.BOOLEAN, false);
                    ReceivedMessagesStorage messagesStorage = wrapper.user().get(ReceivedMessagesStorage.class);
                    messagesStorage.resetUnacknowledgedCount();
                    wrapper.write(Type.PLAYER_MESSAGE_SIGNATURE_ARRAY, messagesStorage.lastSignatures());
                    wrapper.write(Type.OPTIONAL_PLAYER_MESSAGE_SIGNATURE, null);
                });
                this.read(Type.VAR_INT);
                this.read(ACKNOWLEDGED_BIT_SET_TYPE);
            }
        }, true);
        this.registerServerbound(ServerboundPackets1_19_3.CHAT_MESSAGE, ServerboundPackets1_19_1.CHAT_MESSAGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING);
                this.map(Type.LONG);
                this.map(Type.LONG);
                this.read(OPTIONAL_MESSAGE_SIGNATURE_BYTES_TYPE);
                this.handler(wrapper -> {
                    ChatSession1_19_2 chatSession1192 = wrapper.user().get(ChatSession1_19_2.class);
                    ReceivedMessagesStorage messagesStorage = wrapper.user().get(ReceivedMessagesStorage.class);
                    if (chatSession1192 != null) {
                        UUID sender = wrapper.user().getProtocolInfo().getUuid();
                        String message = wrapper.get(Type.STRING, 0);
                        long timestamp = wrapper.get(Type.LONG, 0);
                        long salt = wrapper.get(Type.LONG, 1);
                        byte[] signature = chatSession1192.sign(sender, new MessageMetadataModel(message, timestamp, salt), messagesStorage.lastSignatures());
                        wrapper.write(Type.BYTE_ARRAY_PRIMITIVE, signature);
                        wrapper.write(Type.BOOLEAN, false);
                    } else {
                        wrapper.write(Type.BYTE_ARRAY_PRIMITIVE, new byte[0]);
                        wrapper.write(Type.BOOLEAN, false);
                    }
                    messagesStorage.resetUnacknowledgedCount();
                    wrapper.write(Type.PLAYER_MESSAGE_SIGNATURE_ARRAY, messagesStorage.lastSignatures());
                    wrapper.write(Type.OPTIONAL_PLAYER_MESSAGE_SIGNATURE, null);
                });
                this.read(Type.VAR_INT);
                this.read(ACKNOWLEDGED_BIT_SET_TYPE);
            }
        }, true);
    }
}

