/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.protocolhack.netty;

import com.viaversion.viaversion.api.connection.UserConnection;
import de.florianmichael.viafabricplus.ViaFabricPlus;
import de.florianmichael.viafabricplus.protocolhack.netty.viabedrock.RakNetClientConnection;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import net.raphimc.vialoader.netty.CompressionReorderEvent;
import net.raphimc.vialoader.netty.VLLegacyPipeline;
import net.raphimc.vialoader.netty.viabedrock.PingEncapsulationCodec;
import net.raphimc.vialoader.util.VersionEnum;

public class ViaFabricPlusVLLegacyPipeline
extends VLLegacyPipeline {
    public static final String VIABEDROCK_COMPRESSION_HANDLER_NAME = "viabedrock-compression";
    public static final String VIABEDROCK_ENCRYPTION_HANDLER_NAME = "viabedrock-encryption";
    private final InetSocketAddress address;

    public ViaFabricPlusVLLegacyPipeline(UserConnection user, VersionEnum version, InetSocketAddress address) {
        super(user, version);
        this.address = address;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        if (this.version == VersionEnum.bedrockLatest && RakNetClientConnection.getRakNetPingSessions().contains(this.address)) {
            ctx.pipeline().replace("viabedrock-frame-encapsulation", "viabedrock-frame-encapsulation", (ChannelHandler)new PingEncapsulationCodec(this.address));
            ctx.pipeline().remove("viabedrock-packet-encapsulation");
            ctx.pipeline().remove(this.lengthSplitterName());
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt.getClass().getName().equals("me.steinborn.krypton.mod.shared.misc.KryptonPipelineEvent") && evt.toString().equals("COMPRESSION_ENABLED")) {
            super.userEventTriggered(ctx, CompressionReorderEvent.INSTANCE);
            ViaFabricPlus.LOGGER.info("Compression has been re-ordered after \"Krypton\"");
            return;
        }
        super.userEventTriggered(ctx, evt);
    }

    @Override
    protected String decompressName() {
        return "decompress";
    }

    @Override
    protected String compressName() {
        return "compress";
    }

    @Override
    protected String packetDecoderName() {
        return "decoder";
    }

    @Override
    protected String packetEncoderName() {
        return "encoder";
    }

    @Override
    protected String lengthSplitterName() {
        return "splitter";
    }

    @Override
    protected String lengthPrependerName() {
        return "prepender";
    }
}

