/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.protocolhack.provider.vialegacy;

import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.net.Proxy;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.model.GameProfile;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.providers.GameProfileFetcher;

public class ViaFabricPlusGameProfileFetcher
extends GameProfileFetcher {
    public static final HttpAuthenticationService AUTHENTICATION_SERVICE = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
    public static final MinecraftSessionService SESSION_SERVICE = AUTHENTICATION_SERVICE.createMinecraftSessionService();
    public static final GameProfileRepository GAME_PROFILE_REPOSITORY = AUTHENTICATION_SERVICE.createProfileRepository();

    @Override
    public UUID loadMojangUUID(String playerName) throws Exception {
        final CompletableFuture future = new CompletableFuture();
        GAME_PROFILE_REPOSITORY.findProfilesByNames(new String[]{playerName}, Agent.MINECRAFT, new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile profile) {
                future.complete(profile);
            }

            public void onProfileLookupFailed(GameProfile profile, Exception exception) {
                future.completeExceptionally(exception);
            }
        });
        if (!future.isDone()) {
            future.completeExceptionally((Throwable)new ProfileNotFoundException());
        }
        return ((GameProfile)future.get()).getId();
    }

    @Override
    public net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.model.GameProfile loadGameProfile(UUID uuid) throws Exception {
        GameProfile inProfile = new GameProfile(uuid, null);
        GameProfile mojangProfile = SESSION_SERVICE.fillProfileProperties(inProfile, true);
        if (mojangProfile.equals((Object)inProfile)) {
            throw new ProfileNotFoundException();
        }
        net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.model.GameProfile gameProfile = new net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.model.GameProfile(mojangProfile.getName(), mojangProfile.getId());
        for (Map.Entry entry : mojangProfile.getProperties().entries()) {
            Property prop = (Property)entry.getValue();
            gameProfile.addProperty(new GameProfile.Property(prop.getName(), prop.getValue(), prop.getSignature()));
        }
        return gameProfile;
    }
}

