/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.lenni0451.mcstructs.nbt.INbtTag;
import net.lenni0451.mcstructs.nbt.tags.ByteArrayTag;
import net.lenni0451.mcstructs.nbt.tags.ByteTag;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.nbt.tags.DoubleTag;
import net.lenni0451.mcstructs.nbt.tags.FloatTag;
import net.lenni0451.mcstructs.nbt.tags.IntArrayTag;
import net.lenni0451.mcstructs.nbt.tags.IntTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;
import net.lenni0451.mcstructs.nbt.tags.LongArrayTag;
import net.lenni0451.mcstructs.nbt.tags.LongTag;
import net.lenni0451.mcstructs.nbt.tags.ShortTag;
import net.lenni0451.mcstructs.nbt.tags.StringTag;

public enum NbtType {
    END(0, null, () -> null, null),
    BYTE(1, ByteTag.class, ByteTag::new, Byte.TYPE),
    SHORT(2, ShortTag.class, ShortTag::new, Short.TYPE),
    INT(3, IntTag.class, IntTag::new, Integer.TYPE),
    LONG(4, LongTag.class, LongTag::new, Long.TYPE),
    FLOAT(5, FloatTag.class, FloatTag::new, Float.TYPE),
    DOUBLE(6, DoubleTag.class, DoubleTag::new, Double.TYPE),
    BYTE_ARRAY(7, ByteArrayTag.class, ByteArrayTag::new, byte[].class),
    STRING(8, StringTag.class, StringTag::new, String.class),
    LIST(9, ListTag.class, ListTag::new, List.class),
    COMPOUND(10, CompoundTag.class, CompoundTag::new, Map.class),
    INT_ARRAY(11, IntArrayTag.class, IntArrayTag::new, int[].class),
    LONG_ARRAY(12, LongArrayTag.class, LongArrayTag::new, long[].class);

    private final int id;
    private final Class<? extends INbtTag> tagClass;
    private final Supplier<?> tagSupplier;
    private final Class<?> dataType;

    @Nullable
    public static NbtType byName(String name) {
        for (NbtType type : NbtType.values()) {
            if (!type.name().equals(name)) continue;
            return type;
        }
        return null;
    }

    @Nullable
    public static NbtType byId(int id) {
        for (NbtType type : NbtType.values()) {
            if (type.getId() != id) continue;
            return type;
        }
        return null;
    }

    @Nullable
    public static NbtType byClass(Class<? extends INbtTag> tagClass) {
        for (NbtType type : NbtType.values()) {
            if (!Objects.equals(type.getTagClass(), tagClass)) continue;
            return type;
        }
        return null;
    }

    @Nullable
    public static NbtType byDataType(Class<?> dataType) {
        for (NbtType type : NbtType.values()) {
            if (!Objects.equals(type.getDataType(), dataType)) continue;
            return type;
        }
        return null;
    }

    private NbtType(int id, Class<? extends INbtTag> tagClass, Supplier<?> tagSupplier, Class<?> dataType) {
        this.id = id;
        this.tagClass = tagClass;
        this.tagSupplier = tagSupplier;
        this.dataType = dataType;
    }

    public int getId() {
        return this.id;
    }

    public Class<? extends INbtTag> getTagClass() {
        return this.tagClass;
    }

    public INbtTag newInstance() {
        if (this.tagClass == null) {
            throw new IllegalStateException("Unable to create a new instance of END tag");
        }
        return (INbtTag)this.tagSupplier.get();
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    public boolean isNumber() {
        if (this.dataType == null) {
            return false;
        }
        return Byte.TYPE.equals(this.dataType) || Short.TYPE.equals(this.dataType) || Integer.TYPE.equals(this.dataType) || Long.TYPE.equals(this.dataType) || Float.TYPE.equals(this.dataType) || Double.TYPE.equals(this.dataType);
    }
}

