/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.io;

import net.lenni0451.mcstructs.nbt.exceptions.NbtReadException;

public class NbtReadTracker {
    public static final int DEFAULT_MAX_BYTES = 0x200000;
    public static final int DEFAULT_MAX_DEPTH = 512;
    private final int maxDepth;
    private final int maxBytes;
    private int depth;
    private int size;

    public static NbtReadTracker unlimited() {
        return new NbtReadTracker(0){

            @Override
            public void read(int bytes) {
            }
        };
    }

    public NbtReadTracker() {
        this(0x200000);
    }

    public NbtReadTracker(int maxBytes) {
        this(512, maxBytes);
    }

    public NbtReadTracker(int maxDepth, int maxBytes) {
        this.maxDepth = maxDepth;
        this.maxBytes = maxBytes;
    }

    public void pushDepth() throws NbtReadException {
        ++this.depth;
        if (this.depth > 512) {
            throw new NbtReadException("Tried to read Nbt with more depth than allowed (" + this.maxDepth + ")");
        }
    }

    public void popDepth() {
        --this.depth;
    }

    public void read(int bytes) throws NbtReadException {
        this.size += bytes;
        if (this.size > this.maxBytes) {
            throw new NbtReadException("Tried to read larger Nbt than allowed. Needed bytes " + this.size + " but max is " + this.maxBytes + " bytes");
        }
    }
}

