/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.io.internal;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import net.lenni0451.mcstructs.nbt.INbtTag;
import net.lenni0451.mcstructs.nbt.io.NamedTag;
import net.lenni0451.mcstructs.nbt.io.NbtHeader;
import net.lenni0451.mcstructs.nbt.io.NbtReadTracker;
import net.lenni0451.mcstructs.nbt.io.types.INbtReader;

public interface NbtReadWrapper {
    public INbtReader getReader();

    @Nullable
    default public INbtTag readFile(File f, @Nonnull NbtReadTracker readTracker) throws IOException {
        return this.readFile(f, false, readTracker);
    }

    @Nullable
    default public INbtTag readCompressedFile(File f, @Nonnull NbtReadTracker readTracker) throws IOException {
        return this.readFile(f, true, readTracker);
    }

    @Nullable
    default public INbtTag readFile(File f, boolean compressed, @Nonnull NbtReadTracker readTracker) throws IOException {
        try (InputStream fis = Files.newInputStream(f.toPath(), new OpenOption[0]);){
            INbtTag iNbtTag = this.read(fis, compressed, readTracker);
            return iNbtTag;
        }
    }

    @Nullable
    @WillNotClose
    default public INbtTag read(InputStream is, boolean compressed, @Nonnull NbtReadTracker readTracker) throws IOException {
        if (compressed) {
            return this.read(new DataInputStream(new GZIPInputStream(is)), readTracker);
        }
        return this.read(new DataInputStream(is), readTracker);
    }

    @Nullable
    @WillNotClose
    default public INbtTag read(DataInput in, @Nonnull NbtReadTracker readTracker) throws IOException {
        NamedTag named = this.readNamed(in, readTracker);
        if (named == null) {
            return null;
        }
        return named.getTag();
    }

    @Nullable
    default public NamedTag readNamed(DataInput in, @Nonnull NbtReadTracker readTracker) throws IOException {
        NbtHeader header = this.getReader().readHeader(in, readTracker);
        if (header.isEnd()) {
            return null;
        }
        readTracker.pushDepth();
        INbtTag tag = this.getReader().read(header.getType(), in, readTracker);
        readTracker.popDepth();
        return new NamedTag(header.getName(), header.getType(), tag);
    }
}

