/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.io.internal;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import net.lenni0451.mcstructs.nbt.INbtTag;
import net.lenni0451.mcstructs.nbt.io.NbtHeader;
import net.lenni0451.mcstructs.nbt.io.types.INbtWriter;

public interface NbtWriteWrapper {
    public INbtWriter getWriter();

    default public void writeFile(File f, @Nonnull String name, INbtTag tag) throws IOException {
        this.writeFile(f, name, tag, false);
    }

    default public void writeCompressedFile(File f, @Nonnull String name, INbtTag tag) throws IOException {
        this.writeFile(f, name, tag, true);
    }

    default public void writeFile(File f, @Nonnull String name, INbtTag tag, boolean compressed) throws IOException {
        try (OutputStream fos = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
            this.write(fos, name, tag, compressed);
        }
    }

    @WillClose
    default public void write(OutputStream os, @Nonnull String name, INbtTag tag, boolean compressed) throws IOException {
        if (compressed) {
            try (GZIPOutputStream gos = new GZIPOutputStream(os);){
                this.write(new DataOutputStream(gos), name, tag);
            }
        } else {
            this.write(new DataOutputStream(os), name, tag);
        }
    }

    @WillNotClose
    default public void write(DataOutput out, @Nonnull String name, INbtTag tag) throws IOException {
        this.getWriter().writeHeader(out, new NbtHeader(tag.getNbtType(), name));
        this.getWriter().write(out, tag);
    }
}

