/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.io.types;

import java.io.DataInput;
import java.io.IOException;
import net.lenni0451.mcstructs.nbt.INbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.io.NbtHeader;
import net.lenni0451.mcstructs.nbt.io.NbtReadTracker;
import net.lenni0451.mcstructs.nbt.tags.ByteArrayTag;
import net.lenni0451.mcstructs.nbt.tags.ByteTag;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.nbt.tags.DoubleTag;
import net.lenni0451.mcstructs.nbt.tags.FloatTag;
import net.lenni0451.mcstructs.nbt.tags.IntArrayTag;
import net.lenni0451.mcstructs.nbt.tags.IntTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;
import net.lenni0451.mcstructs.nbt.tags.LongArrayTag;
import net.lenni0451.mcstructs.nbt.tags.LongTag;
import net.lenni0451.mcstructs.nbt.tags.ShortTag;
import net.lenni0451.mcstructs.nbt.tags.StringTag;

public interface INbtReader {
    public NbtHeader readHeader(DataInput var1, NbtReadTracker var2) throws IOException;

    default public INbtTag read(NbtType type, DataInput in, NbtReadTracker readTracker) throws IOException {
        switch (type) {
            case BYTE: {
                return this.readByte(in, readTracker);
            }
            case SHORT: {
                return this.readShort(in, readTracker);
            }
            case INT: {
                return this.readInt(in, readTracker);
            }
            case LONG: {
                return this.readLong(in, readTracker);
            }
            case FLOAT: {
                return this.readFloat(in, readTracker);
            }
            case DOUBLE: {
                return this.readDouble(in, readTracker);
            }
            case BYTE_ARRAY: {
                return this.readByteArray(in, readTracker);
            }
            case STRING: {
                return this.readString(in, readTracker);
            }
            case LIST: {
                return this.readList(in, readTracker);
            }
            case COMPOUND: {
                return this.readCompound(in, readTracker);
            }
            case INT_ARRAY: {
                return this.readIntArray(in, readTracker);
            }
            case LONG_ARRAY: {
                return this.readLongArray(in, readTracker);
            }
        }
        throw new IOException("Unknown tag type: " + (Object)((Object)type));
    }

    public ByteTag readByte(DataInput var1, NbtReadTracker var2) throws IOException;

    public ShortTag readShort(DataInput var1, NbtReadTracker var2) throws IOException;

    public IntTag readInt(DataInput var1, NbtReadTracker var2) throws IOException;

    public LongTag readLong(DataInput var1, NbtReadTracker var2) throws IOException;

    public FloatTag readFloat(DataInput var1, NbtReadTracker var2) throws IOException;

    public DoubleTag readDouble(DataInput var1, NbtReadTracker var2) throws IOException;

    public ByteArrayTag readByteArray(DataInput var1, NbtReadTracker var2) throws IOException;

    public StringTag readString(DataInput var1, NbtReadTracker var2) throws IOException;

    public ListTag<?> readList(DataInput var1, NbtReadTracker var2) throws IOException;

    public CompoundTag readCompound(DataInput var1, NbtReadTracker var2) throws IOException;

    public IntArrayTag readIntArray(DataInput var1, NbtReadTracker var2) throws IOException;

    public LongArrayTag readLongArray(DataInput var1, NbtReadTracker var2) throws IOException;
}

