/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.io.types;

import java.io.DataOutput;
import java.io.IOException;
import net.lenni0451.mcstructs.nbt.INbtTag;
import net.lenni0451.mcstructs.nbt.io.NbtHeader;
import net.lenni0451.mcstructs.nbt.tags.ByteArrayTag;
import net.lenni0451.mcstructs.nbt.tags.ByteTag;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.nbt.tags.DoubleTag;
import net.lenni0451.mcstructs.nbt.tags.FloatTag;
import net.lenni0451.mcstructs.nbt.tags.IntArrayTag;
import net.lenni0451.mcstructs.nbt.tags.IntTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;
import net.lenni0451.mcstructs.nbt.tags.LongArrayTag;
import net.lenni0451.mcstructs.nbt.tags.LongTag;
import net.lenni0451.mcstructs.nbt.tags.ShortTag;
import net.lenni0451.mcstructs.nbt.tags.StringTag;

public interface INbtWriter {
    public void writeHeader(DataOutput var1, NbtHeader var2) throws IOException;

    default public void write(DataOutput out, INbtTag tag) throws IOException {
        if (tag instanceof ByteTag) {
            this.writeByte(out, (ByteTag)tag);
        } else if (tag instanceof ShortTag) {
            this.writeShort(out, (ShortTag)tag);
        } else if (tag instanceof IntTag) {
            this.writeInt(out, (IntTag)tag);
        } else if (tag instanceof LongTag) {
            this.writeLong(out, (LongTag)tag);
        } else if (tag instanceof FloatTag) {
            this.writeFloat(out, (FloatTag)tag);
        } else if (tag instanceof DoubleTag) {
            this.writeDouble(out, (DoubleTag)tag);
        } else if (tag instanceof ByteArrayTag) {
            this.writeByteArray(out, (ByteArrayTag)tag);
        } else if (tag instanceof StringTag) {
            this.writeString(out, (StringTag)tag);
        } else if (tag instanceof ListTag) {
            this.writeList(out, (ListTag)tag);
        } else if (tag instanceof CompoundTag) {
            this.writeCompound(out, (CompoundTag)tag);
        } else if (tag instanceof IntArrayTag) {
            this.writeIntArray(out, (IntArrayTag)tag);
        } else if (tag instanceof LongArrayTag) {
            this.writeLongArray(out, (LongArrayTag)tag);
        } else {
            throw new IllegalArgumentException("Unknown tag type: " + tag.getClass().getName());
        }
    }

    public void writeByte(DataOutput var1, ByteTag var2) throws IOException;

    public void writeShort(DataOutput var1, ShortTag var2) throws IOException;

    public void writeInt(DataOutput var1, IntTag var2) throws IOException;

    public void writeLong(DataOutput var1, LongTag var2) throws IOException;

    public void writeFloat(DataOutput var1, FloatTag var2) throws IOException;

    public void writeDouble(DataOutput var1, DoubleTag var2) throws IOException;

    public void writeByteArray(DataOutput var1, ByteArrayTag var2) throws IOException;

    public void writeString(DataOutput var1, StringTag var2) throws IOException;

    public void writeList(DataOutput var1, ListTag<?> var2) throws IOException;

    public void writeCompound(DataOutput var1, CompoundTag var2) throws IOException;

    public void writeIntArray(DataOutput var1, IntArrayTag var2) throws IOException;

    public void writeLongArray(DataOutput var1, LongArrayTag var2) throws IOException;
}

