/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.tags;

import java.util.Arrays;
import java.util.Iterator;
import net.lenni0451.mcstructs.nbt.INbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.tags.ByteTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;

public class ByteArrayTag
implements INbtTag,
Iterable<Byte> {
    private byte[] value;

    public ByteArrayTag() {
        this(new byte[0]);
    }

    public ByteArrayTag(ListTag<ByteTag> list) {
        this.value = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.value[i] = list.get(i).getValue();
        }
    }

    public ByteArrayTag(byte[] value) {
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    public ByteArrayTag setValue(byte[] value) {
        this.value = value;
        return this;
    }

    public byte get(int index) {
        return this.value[index];
    }

    public ByteArrayTag set(int index, byte b) {
        this.value[index] = b;
        return this;
    }

    public ByteArrayTag add(byte b) {
        byte[] newValue = new byte[this.value.length + 1];
        System.arraycopy(this.value, 0, newValue, 0, this.value.length);
        newValue[this.value.length] = b;
        this.value = newValue;
        return this;
    }

    public int getLength() {
        return this.value.length;
    }

    public boolean isEmpty() {
        return this.value.length == 0;
    }

    @Override
    public NbtType getNbtType() {
        return NbtType.BYTE_ARRAY;
    }

    @Override
    public INbtTag copy() {
        return new ByteArrayTag((byte[])this.value.clone());
    }

    @Override
    public Iterator<Byte> iterator() {
        return new Iterator<Byte>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ByteArrayTag.this.value.length;
            }

            @Override
            public Byte next() {
                return ByteArrayTag.this.value[this.index++];
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArrayTag that = (ByteArrayTag)o;
        return Arrays.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public String toString() {
        return "byte[" + this.value.length + "](" + Arrays.toString(this.value) + ")";
    }
}

