/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.tags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.lenni0451.mcstructs.nbt.INbtNumber;
import net.lenni0451.mcstructs.nbt.INbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.exceptions.UnknownTagTypeException;
import net.lenni0451.mcstructs.nbt.tags.ByteArrayTag;
import net.lenni0451.mcstructs.nbt.tags.ByteTag;
import net.lenni0451.mcstructs.nbt.tags.DoubleTag;
import net.lenni0451.mcstructs.nbt.tags.FloatTag;
import net.lenni0451.mcstructs.nbt.tags.IntArrayTag;
import net.lenni0451.mcstructs.nbt.tags.IntTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;
import net.lenni0451.mcstructs.nbt.tags.LongArrayTag;
import net.lenni0451.mcstructs.nbt.tags.LongTag;
import net.lenni0451.mcstructs.nbt.tags.ShortTag;
import net.lenni0451.mcstructs.nbt.tags.StringTag;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CompoundTag
implements INbtTag,
Iterable<Map.Entry<String, INbtTag>> {
    private Map<String, INbtTag> value;

    public CompoundTag() {
        this.value = new HashMap<String, INbtTag>();
    }

    public CompoundTag(Map<String, INbtTag> value) {
        this.value = value;
    }

    public Map<String, INbtTag> getValue() {
        return this.value;
    }

    public CompoundTag setValue(Map<String, INbtTag> value) {
        this.value = value;
        return this;
    }

    public int size() {
        return this.value.size();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public boolean contains(String key) {
        return this.value.containsKey(key);
    }

    public boolean contains(String key, NbtType type) {
        Object tag = this.get(key);
        if (tag == null) {
            return false;
        }
        if (type.isNumber() && tag.getNbtType().isNumber()) {
            return true;
        }
        return tag.getNbtType().equals((Object)type);
    }

    public boolean containsExact(String key, NbtType type) {
        Object tag = this.get(key);
        if (tag == null) {
            return false;
        }
        return tag.getNbtType().equals((Object)type);
    }

    @Nullable
    public <T extends INbtTag> T get(String key) {
        return (T)this.value.get(key);
    }

    public CompoundTag add(String key, INbtTag tag) {
        this.value.put(key, tag);
        return this;
    }

    public CompoundTag add(String key, Object o) {
        return this.add(key, this.wrap(o));
    }

    @Nullable
    public INbtTag remove(String key) {
        return this.value.remove(key);
    }

    public byte getByte(String key) {
        if (this.contains(key, NbtType.BYTE)) {
            return ((INbtNumber)this.get(key)).byteValue();
        }
        return 0;
    }

    public CompoundTag addByte(String key, byte b) {
        return this.add(key, new ByteTag(b));
    }

    public short getShort(String key) {
        if (this.contains(key, NbtType.SHORT)) {
            return ((INbtNumber)this.get(key)).shortValue();
        }
        return 0;
    }

    public CompoundTag addShort(String key, short s) {
        return this.add(key, new ShortTag(s));
    }

    public int getInt(String key) {
        if (this.contains(key, NbtType.INT)) {
            return ((INbtNumber)this.get(key)).intValue();
        }
        return 0;
    }

    public CompoundTag addInt(String key, int i) {
        return this.add(key, new IntTag(i));
    }

    public long getLong(String key) {
        if (this.contains(key, NbtType.LONG)) {
            return ((INbtNumber)this.get(key)).longValue();
        }
        return 0L;
    }

    public CompoundTag addLong(String key, long l) {
        return this.add(key, new LongTag(l));
    }

    public float getFloat(String key) {
        if (this.contains(key, NbtType.FLOAT)) {
            return ((INbtNumber)this.get(key)).floatValue();
        }
        return 0.0f;
    }

    public CompoundTag addFloat(String key, float f) {
        return this.add(key, new FloatTag(f));
    }

    public double getDouble(String key) {
        if (this.contains(key, NbtType.DOUBLE)) {
            return ((INbtNumber)this.get(key)).doubleValue();
        }
        return 0.0;
    }

    public CompoundTag addDouble(String key, double d) {
        return this.add(key, new DoubleTag(d));
    }

    public byte[] getByteArray(String key) {
        if (this.contains(key, NbtType.BYTE_ARRAY)) {
            return ((ByteArrayTag)this.get(key)).getValue();
        }
        return new byte[0];
    }

    public CompoundTag addByteArray(String key, byte ... bytes) {
        return this.add(key, new ByteArrayTag(bytes));
    }

    public String getString(String key) {
        if (this.contains(key, NbtType.STRING)) {
            return ((StringTag)this.get(key)).getValue();
        }
        return "";
    }

    public CompoundTag addString(String key, String s) {
        return this.add(key, new StringTag(s));
    }

    public <T extends INbtTag> ListTag<T> getList(String key) {
        if (this.contains(key, NbtType.LIST)) {
            return (ListTag)this.get(key);
        }
        return new ListTag();
    }

    public <T extends INbtTag> ListTag<T> getList(String key, NbtType type) {
        if (this.contains(key, NbtType.LIST)) {
            ListTag list = (ListTag)this.get(key);
            if (!list.canAdd(type)) {
                return new ListTag(type);
            }
            return list;
        }
        return new ListTag();
    }

    public CompoundTag addList(String key, ListTag<?> list) {
        return this.add(key, list);
    }

    public <T extends INbtTag> void addList(String key, T ... items) {
        if (items.length == 0) {
            this.add(key, new ListTag());
        } else {
            ArrayList list = new ArrayList();
            Collections.addAll(list, items);
            this.add(key, new ListTag(list));
        }
    }

    public CompoundTag addList(String key, Object ... items) {
        if (items.length == 0) {
            this.add(key, new ListTag());
        } else {
            ArrayList<INbtTag> list = new ArrayList<INbtTag>();
            for (Object item : items) {
                list.add(this.wrap(item));
            }
            this.add(key, new ListTag(list));
        }
        return this;
    }

    public CompoundTag getCompound(String key) {
        if (this.contains(key, NbtType.COMPOUND)) {
            return (CompoundTag)this.get(key);
        }
        return new CompoundTag();
    }

    public CompoundTag addCompound(String key, CompoundTag compound) {
        return this.add(key, compound);
    }

    public int[] getIntArray(String key) {
        if (this.contains(key, NbtType.INT_ARRAY)) {
            return ((IntArrayTag)this.get(key)).getValue();
        }
        return new int[0];
    }

    public CompoundTag addIntArray(String key, int ... ints) {
        return this.add(key, new IntArrayTag(ints));
    }

    public long[] getLongArray(String key) {
        if (this.contains(key, NbtType.LONG_ARRAY)) {
            return ((LongArrayTag)this.get(key)).getValue();
        }
        return new long[0];
    }

    public CompoundTag addLongArray(String key, long ... longs) {
        return this.add(key, new LongArrayTag(longs));
    }

    public boolean trim() {
        if (this.value.isEmpty()) {
            return true;
        }
        this.value.entrySet().removeIf(entry -> {
            INbtTag tag = (INbtTag)entry.getValue();
            if (tag instanceof ByteTag) {
                return ((ByteTag)tag).getValue() == 0;
            }
            if (tag instanceof ShortTag) {
                return ((ShortTag)tag).getValue() == 0;
            }
            if (tag instanceof IntTag) {
                return ((IntTag)tag).getValue() == 0;
            }
            if (tag instanceof LongTag) {
                return ((LongTag)tag).getValue() == 0L;
            }
            if (tag instanceof FloatTag) {
                return ((FloatTag)tag).getValue() == 0.0f;
            }
            if (tag instanceof DoubleTag) {
                return ((DoubleTag)tag).getValue() == 0.0;
            }
            if (tag instanceof ByteArrayTag) {
                return ((ByteArrayTag)tag).isEmpty();
            }
            if (tag instanceof StringTag) {
                return ((StringTag)tag).getValue().isEmpty();
            }
            if (tag instanceof ListTag) {
                return ((ListTag)tag).trim();
            }
            if (tag instanceof CompoundTag) {
                return ((CompoundTag)tag).trim();
            }
            if (tag instanceof IntArrayTag) {
                return ((IntArrayTag)tag).isEmpty();
            }
            if (tag instanceof LongArrayTag) {
                return ((LongArrayTag)tag).isEmpty();
            }
            return false;
        });
        return this.value.isEmpty();
    }

    private INbtTag wrap(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof INbtTag) {
            return (INbtTag)o;
        }
        if (o instanceof Byte) {
            return new ByteTag((Byte)o);
        }
        if (o instanceof Short) {
            return new ShortTag((Short)o);
        }
        if (o instanceof Integer) {
            return new IntTag((Integer)o);
        }
        if (o instanceof Long) {
            return new LongTag((Long)o);
        }
        if (o instanceof Float) {
            return new FloatTag(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return new DoubleTag((Double)o);
        }
        if (o instanceof byte[]) {
            return new ByteArrayTag((byte[])o);
        }
        if (o instanceof String) {
            return new StringTag((String)o);
        }
        if (o instanceof int[]) {
            return new IntArrayTag((int[])o);
        }
        if (o instanceof long[]) {
            return new LongArrayTag((long[])o);
        }
        throw new UnknownTagTypeException(o.getClass());
    }

    @Override
    public NbtType getNbtType() {
        return NbtType.COMPOUND;
    }

    @Override
    public INbtTag copy() {
        HashMap<String, INbtTag> value = new HashMap<String, INbtTag>();
        for (Map.Entry<String, INbtTag> entry : this.value.entrySet()) {
            value.put(entry.getKey(), entry.getValue().copy());
        }
        return new CompoundTag(value);
    }

    @Override
    public Iterator<Map.Entry<String, INbtTag>> iterator() {
        return this.value.entrySet().iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompoundTag that = (CompoundTag)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public String toString() {
        return "Compound[" + this.value.size() + "]" + this.value;
    }
}

