/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.tags;

import java.util.Arrays;
import java.util.Iterator;
import net.lenni0451.mcstructs.nbt.INbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.tags.IntTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;

public class IntArrayTag
implements INbtTag,
Iterable<Integer> {
    private int[] value;

    public IntArrayTag() {
        this(new int[0]);
    }

    public IntArrayTag(ListTag<IntTag> list) {
        this.value = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.value[i] = list.get(i).getValue();
        }
    }

    public IntArrayTag(int[] value) {
        this.value = value;
    }

    public int[] getValue() {
        return this.value;
    }

    public IntArrayTag setValue(int[] value) {
        this.value = value;
        return this;
    }

    public int get(int index) {
        return this.value[index];
    }

    public IntArrayTag set(int index, int i) {
        this.value[index] = i;
        return this;
    }

    public IntArrayTag add(int i) {
        int[] newValue = new int[this.value.length + 1];
        System.arraycopy(this.value, 0, newValue, 0, this.value.length);
        newValue[this.value.length] = i;
        this.value = newValue;
        return this;
    }

    public int getLength() {
        return this.value.length;
    }

    public boolean isEmpty() {
        return this.value.length == 0;
    }

    @Override
    public NbtType getNbtType() {
        return NbtType.INT_ARRAY;
    }

    @Override
    public INbtTag copy() {
        return new IntArrayTag((int[])this.value.clone());
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < IntArrayTag.this.value.length;
            }

            @Override
            public Integer next() {
                return IntArrayTag.this.value[this.index++];
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntArrayTag that = (IntArrayTag)o;
        return Arrays.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public String toString() {
        return "int[" + this.value.length + "](" + Arrays.toString(this.value) + ")";
    }
}

