/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.nbt.tags;

import java.util.Objects;
import net.lenni0451.mcstructs.nbt.INbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;

public class StringTag
implements INbtTag {
    private String value;

    public StringTag() {
        this("");
    }

    public StringTag(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public StringTag setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public NbtType getNbtType() {
        return NbtType.STRING;
    }

    @Override
    public INbtTag copy() {
        return new StringTag(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringTag stringTag = (StringTag)o;
        return Objects.equals(this.value, stringTag.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public String toString() {
        return "String(" + this.value + ")";
    }
}

