/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.snbt;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.lenni0451.mcstructs.nbt.INbtTag;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.snbt.ISNbtDeserializer;
import net.lenni0451.mcstructs.snbt.ISNbtSerializer;
import net.lenni0451.mcstructs.snbt.exceptions.SNbtDeserializeException;
import net.lenni0451.mcstructs.snbt.exceptions.SNbtSerializeException;
import net.lenni0451.mcstructs.snbt.impl.v1_12.SNbtDeserializer_v1_12;
import net.lenni0451.mcstructs.snbt.impl.v1_12.SNbtSerializer_v1_12;
import net.lenni0451.mcstructs.snbt.impl.v1_13.SNbtDeserializer_v1_13;
import net.lenni0451.mcstructs.snbt.impl.v1_14.SNbtDeserializer_v1_14;
import net.lenni0451.mcstructs.snbt.impl.v1_14.SNbtSerializer_v1_14;
import net.lenni0451.mcstructs.snbt.impl.v1_7.SNbtDeserializer_v1_7;
import net.lenni0451.mcstructs.snbt.impl.v1_7.SNbtSerializer_v1_7;
import net.lenni0451.mcstructs.snbt.impl.v1_8.SNbtDeserializer_v1_8;
import net.lenni0451.mcstructs.snbt.impl.v1_8.SNbtSerializer_v1_8;

public class SNbtSerializer<T extends INbtTag> {
    public static final SNbtSerializer<INbtTag> V1_7 = new SNbtSerializer(SNbtSerializer_v1_7::new, SNbtDeserializer_v1_7::new);
    public static final SNbtSerializer<CompoundTag> V1_8 = new SNbtSerializer(SNbtSerializer_v1_8::new, SNbtDeserializer_v1_8::new);
    public static final SNbtSerializer<CompoundTag> V1_12 = new SNbtSerializer(SNbtSerializer_v1_12::new, SNbtDeserializer_v1_12::new);
    public static final SNbtSerializer<CompoundTag> V1_13 = new SNbtSerializer(SNbtSerializer_v1_12::new, SNbtDeserializer_v1_13::new);
    public static final SNbtSerializer<CompoundTag> V1_14 = new SNbtSerializer(SNbtSerializer_v1_14::new, SNbtDeserializer_v1_14::new);
    private final Supplier<ISNbtSerializer> serializerSupplier;
    private final Supplier<ISNbtDeserializer<T>> deserializerSupplier;
    private ISNbtSerializer serializer;
    private ISNbtDeserializer<T> deserializer;

    public SNbtSerializer(Supplier<ISNbtSerializer> serializerSupplier, Supplier<ISNbtDeserializer<T>> deserializerSupplier) {
        this.serializerSupplier = serializerSupplier;
        this.deserializerSupplier = deserializerSupplier;
    }

    public ISNbtSerializer getSerializer() {
        if (this.serializer == null) {
            this.serializer = this.serializerSupplier.get();
        }
        return this.serializer;
    }

    public ISNbtDeserializer<T> getDeserializer() {
        if (this.deserializer == null) {
            this.deserializer = this.deserializerSupplier.get();
        }
        return this.deserializer;
    }

    public String serialize(INbtTag tag) throws SNbtSerializeException {
        return this.getSerializer().serialize(tag);
    }

    @Nullable
    public String trySerialize(INbtTag tag) {
        try {
            return this.serialize(tag);
        }
        catch (SNbtSerializeException t) {
            return null;
        }
    }

    public T deserialize(String s) throws SNbtDeserializeException {
        return this.getDeserializer().deserialize(s);
    }

    @Nullable
    public T tryDeserialize(String s) {
        try {
            return this.deserialize(s);
        }
        catch (SNbtDeserializeException t) {
            return null;
        }
    }
}

