/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.snbt.impl.v1_12;

import java.util.Map;
import java.util.regex.Pattern;
import net.lenni0451.mcstructs.nbt.INbtTag;
import net.lenni0451.mcstructs.nbt.tags.ByteArrayTag;
import net.lenni0451.mcstructs.nbt.tags.ByteTag;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.nbt.tags.DoubleTag;
import net.lenni0451.mcstructs.nbt.tags.FloatTag;
import net.lenni0451.mcstructs.nbt.tags.IntArrayTag;
import net.lenni0451.mcstructs.nbt.tags.IntTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;
import net.lenni0451.mcstructs.nbt.tags.LongArrayTag;
import net.lenni0451.mcstructs.nbt.tags.LongTag;
import net.lenni0451.mcstructs.nbt.tags.ShortTag;
import net.lenni0451.mcstructs.nbt.tags.StringTag;
import net.lenni0451.mcstructs.snbt.ISNbtSerializer;
import net.lenni0451.mcstructs.snbt.exceptions.SNbtSerializeException;

public class SNbtSerializer_v1_12
implements ISNbtSerializer {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("[A-Za-z0-9._+-]+");

    @Override
    public String serialize(INbtTag tag) throws SNbtSerializeException {
        if (tag instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag;
            return byteTag.getValue() + "b";
        }
        if (tag instanceof ShortTag) {
            ShortTag shortTag = (ShortTag)tag;
            return shortTag.getValue() + "s";
        }
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            return String.valueOf(intTag.getValue());
        }
        if (tag instanceof LongTag) {
            LongTag longTag = (LongTag)tag;
            return longTag.getValue() + "L";
        }
        if (tag instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)tag;
            return floatTag.getValue() + "f";
        }
        if (tag instanceof DoubleTag) {
            DoubleTag doubleTag = (DoubleTag)tag;
            return doubleTag.getValue() + "d";
        }
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag byteArrayTag = (ByteArrayTag)tag;
            StringBuilder out = new StringBuilder("[B;");
            for (int i = 0; i < byteArrayTag.getLength(); ++i) {
                if (i != 0) {
                    out.append(",");
                }
                out.append(byteArrayTag.get(i)).append("B");
            }
            return out.append("]").toString();
        }
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            return this.escape(stringTag.getValue());
        }
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            StringBuilder out = new StringBuilder("[");
            for (int i = 0; i < listTag.size(); ++i) {
                if (i != 0) {
                    out.append(",");
                }
                out.append(this.serialize((INbtTag)listTag.get(i)));
            }
            return out.append("]").toString();
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            StringBuilder out = new StringBuilder("{");
            for (Map.Entry<String, INbtTag> entry : compoundTag.getValue().entrySet()) {
                if (out.length() != 1) {
                    out.append(",");
                }
                out.append(this.checkEscape(entry.getKey())).append(":").append(this.serialize(entry.getValue()));
            }
            return out.append("}").toString();
        }
        if (tag instanceof IntArrayTag) {
            IntArrayTag intArrayTag = (IntArrayTag)tag;
            StringBuilder out = new StringBuilder("[I;");
            for (int i = 0; i < intArrayTag.getLength(); ++i) {
                if (i != 0) {
                    out.append(",");
                }
                out.append(intArrayTag.get(i));
            }
            return out.append("]").toString();
        }
        if (tag instanceof LongArrayTag) {
            LongArrayTag longArrayTag = (LongArrayTag)tag;
            StringBuilder out = new StringBuilder("[L;");
            for (int i = 0; i < longArrayTag.getLength(); ++i) {
                if (i != 0) {
                    out.append(",");
                }
                out.append(longArrayTag.get(i)).append("L");
            }
            return out.append("]").toString();
        }
        throw new SNbtSerializeException(tag.getNbtType());
    }

    protected String checkEscape(String s) {
        if (ESCAPE_PATTERN.matcher(s).matches()) {
            return s;
        }
        return this.escape(s);
    }

    protected String escape(String s) {
        char[] chars;
        StringBuilder out = new StringBuilder("\"");
        for (char c : chars = s.toCharArray()) {
            if (c == '\\' || c == '\"') {
                out.append("\\");
            }
            out.append(c);
        }
        return out.append("\"").toString();
    }
}

