/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.text.events.hover.impl;

import java.util.Objects;
import java.util.UUID;
import net.lenni0451.mcstructs.core.Identifier;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.snbt.SNbtSerializer;
import net.lenni0451.mcstructs.snbt.exceptions.SNbtSerializeException;
import net.lenni0451.mcstructs.text.ATextComponent;
import net.lenni0451.mcstructs.text.components.StringComponent;
import net.lenni0451.mcstructs.text.events.hover.AHoverEvent;
import net.lenni0451.mcstructs.text.events.hover.HoverEventAction;
import net.lenni0451.mcstructs.text.events.hover.impl.TextHoverEvent;
import net.lenni0451.mcstructs.text.serializer.TextComponentSerializer;

public class EntityHoverEvent
extends AHoverEvent {
    private final Identifier entityType;
    private final UUID uuid;
    private final ATextComponent name;

    public EntityHoverEvent(HoverEventAction action, Identifier entityType, UUID uuid, ATextComponent name) {
        super(action);
        this.entityType = entityType;
        this.uuid = uuid;
        this.name = name;
    }

    public Identifier getEntityType() {
        return this.entityType;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public ATextComponent getName() {
        return this.name;
    }

    @Override
    public TextHoverEvent toLegacy(TextComponentSerializer textComponentSerializer, SNbtSerializer<?> sNbtSerializer) {
        CompoundTag tag = new CompoundTag();
        tag.addString("type", this.entityType.getValue());
        tag.addString("id", this.uuid.toString());
        tag.addString("name", textComponentSerializer.serialize(this.name));
        try {
            return new TextHoverEvent(this.getAction(), new StringComponent(sNbtSerializer.serialize(tag)));
        }
        catch (SNbtSerializeException e) {
            throw new RuntimeException("This should never happen! Please report to the developer immediately!", e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityHoverEvent that = (EntityHoverEvent)o;
        return this.getAction() == that.getAction() && Objects.equals(this.entityType, that.entityType) && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getAction(), this.entityType, this.uuid, this.name});
    }

    @Override
    public String toString() {
        return "EntityHoverEvent{action=" + (Object)((Object)this.getAction()) + ", entityType=" + this.entityType + ", uuid=" + this.uuid + ", name=" + this.name + "}";
    }
}

