/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.text.events.hover.impl;

import java.util.Objects;
import javax.annotation.Nullable;
import net.lenni0451.mcstructs.core.Identifier;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.snbt.SNbtSerializer;
import net.lenni0451.mcstructs.snbt.exceptions.SNbtSerializeException;
import net.lenni0451.mcstructs.text.components.StringComponent;
import net.lenni0451.mcstructs.text.events.hover.AHoverEvent;
import net.lenni0451.mcstructs.text.events.hover.HoverEventAction;
import net.lenni0451.mcstructs.text.events.hover.impl.TextHoverEvent;
import net.lenni0451.mcstructs.text.serializer.TextComponentSerializer;

public class ItemHoverEvent
extends AHoverEvent {
    private final Identifier item;
    private final int count;
    private final CompoundTag nbt;

    public ItemHoverEvent(HoverEventAction action, Identifier item, int count, CompoundTag nbt) {
        super(action);
        this.item = item;
        this.count = count;
        this.nbt = nbt;
    }

    public Identifier getItem() {
        return this.item;
    }

    public int getCount() {
        return this.count;
    }

    @Nullable
    public CompoundTag getNbt() {
        return this.nbt;
    }

    @Override
    public TextHoverEvent toLegacy(TextComponentSerializer textComponentSerializer, SNbtSerializer<?> sNbtSerializer) {
        CompoundTag tag = new CompoundTag();
        tag.addString("id", this.item.getValue());
        tag.addByte("Count", (byte)this.count);
        if (this.nbt != null) {
            tag.addCompound("tag", this.nbt);
        }
        try {
            return new TextHoverEvent(this.getAction(), new StringComponent(sNbtSerializer.serialize(tag)));
        }
        catch (SNbtSerializeException e) {
            throw new RuntimeException("This should never happen! Please report to the developer immediately!", e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemHoverEvent that = (ItemHoverEvent)o;
        return this.count == that.count && this.getAction() == that.getAction() && Objects.equals(this.item, that.item) && Objects.equals(this.nbt, that.nbt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getAction(), this.item, this.count, this.nbt});
    }

    @Override
    public String toString() {
        return "ItemHoverEvent{action=" + (Object)((Object)this.getAction()) + ", item=" + this.item + ", count=" + this.count + ", nbt=" + this.nbt + "}";
    }
}

