/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.text.serializer;

import java.util.function.Function;
import net.lenni0451.mcstructs.core.TextFormatting;
import net.lenni0451.mcstructs.text.ATextComponent;
import net.lenni0451.mcstructs.text.Style;
import net.lenni0451.mcstructs.text.components.StringComponent;

public class LegacyStringDeserializer {
    public static ATextComponent parse(String s, boolean unknownReset) {
        return LegacyStringDeserializer.parse(s, '\u00a7', unknownReset);
    }

    public static ATextComponent parse(String s, char colorChar, boolean unknownReset) {
        return LegacyStringDeserializer.parse(s, colorChar, c -> {
            TextFormatting formatting = TextFormatting.getByCode(c.charValue());
            if (formatting == null) {
                if (unknownReset) {
                    return TextFormatting.RESET;
                }
                return null;
            }
            return formatting;
        });
    }

    public static ATextComponent parse(String s, char colorChar, Function<Character, TextFormatting> formattingResolver) {
        StringReader reader = new StringReader(s);
        Style style = new Style();
        StringBuilder currentPart = new StringBuilder();
        StringComponent out = new StringComponent("");
        while (reader.hasNext()) {
            char c = reader.read();
            if (c == colorChar) {
                char format;
                TextFormatting formatting;
                if (!reader.hasNext() || (formatting = formattingResolver.apply(Character.valueOf(format = reader.read()))) == null) continue;
                if (currentPart.length() != 0) {
                    out.append(new StringComponent(currentPart.toString()).setStyle(style.copy()));
                    currentPart = new StringBuilder();
                    if (formatting.isColor() || TextFormatting.RESET.equals(formatting)) {
                        style = new Style();
                    }
                }
                style.setFormatting(formatting);
                continue;
            }
            currentPart.append(c);
        }
        if (currentPart.length() != 0) {
            out.append(new StringComponent(currentPart.toString()).setStyle(style));
        }
        if (out.getSiblings().size() == 1) {
            return out.getSiblings().get(0);
        }
        return out;
    }

    private static class StringReader {
        private final String s;
        private int cursor = 0;

        private StringReader(String s) {
            this.s = s;
        }

        private char read() {
            return this.s.charAt(this.cursor++);
        }

        private boolean hasNext() {
            return this.cursor < this.s.length();
        }
    }
}

