/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.text.serializer.v1_16;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.UUID;
import net.lenni0451.mcstructs.core.Identifier;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.snbt.SNbtSerializer;
import net.lenni0451.mcstructs.snbt.exceptions.SNbtDeserializeException;
import net.lenni0451.mcstructs.text.ATextComponent;
import net.lenni0451.mcstructs.text.events.hover.AHoverEvent;
import net.lenni0451.mcstructs.text.events.hover.HoverEventAction;
import net.lenni0451.mcstructs.text.events.hover.impl.EntityHoverEvent;
import net.lenni0451.mcstructs.text.events.hover.impl.ItemHoverEvent;
import net.lenni0451.mcstructs.text.events.hover.impl.TextHoverEvent;
import net.lenni0451.mcstructs.text.serializer.TextComponentSerializer;
import net.lenni0451.mcstructs.text.utils.JsonUtils;

public class HoverEventDeserializer_v1_16
implements JsonDeserializer<AHoverEvent> {
    protected final TextComponentSerializer textComponentSerializer;
    protected final SNbtSerializer<?> sNbtSerializer;

    public HoverEventDeserializer_v1_16(TextComponentSerializer textComponentSerializer, SNbtSerializer<?> sNbtSerializer) {
        this.textComponentSerializer = textComponentSerializer;
        this.sNbtSerializer = sNbtSerializer;
    }

    public AHoverEvent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            return null;
        }
        JsonObject rawHoverEvent = json.getAsJsonObject();
        if (rawHoverEvent == null) {
            return null;
        }
        String rawAction = JsonUtils.getString(rawHoverEvent, "action", null);
        if (rawAction == null) {
            return null;
        }
        HoverEventAction action = HoverEventAction.getByName(rawAction);
        if (action == null) {
            return null;
        }
        JsonElement rawContents = rawHoverEvent.get("contents");
        if (rawContents != null) {
            return this.deserialize(action, rawContents);
        }
        ATextComponent text = this.textComponentSerializer.deserialize(rawHoverEvent.get("value"));
        if (text == null) {
            return null;
        }
        return this.deserializeLegacy(action, text);
    }

    protected AHoverEvent deserialize(HoverEventAction action, JsonElement contents) {
        switch (action) {
            case SHOW_TEXT: {
                return new TextHoverEvent(action, this.textComponentSerializer.deserialize(contents));
            }
            case SHOW_ITEM: {
                if (contents.isJsonPrimitive()) {
                    return new ItemHoverEvent(action, Identifier.of(contents.getAsString()), 1, null);
                }
                JsonObject rawItem = JsonUtils.getJsonObject(contents, "item");
                Identifier item = Identifier.of(JsonUtils.getString(rawItem, "id"));
                int count = JsonUtils.getInt(rawItem, "count", 1);
                if (rawItem.has("tag")) {
                    String rawTag = JsonUtils.getString(rawItem, "tag");
                    return new ItemHoverEvent(action, item, count, (CompoundTag)this.sNbtSerializer.tryDeserialize(rawTag));
                }
                return new ItemHoverEvent(action, item, count, null);
            }
            case SHOW_ENTITY: {
                if (!contents.isJsonObject()) {
                    return null;
                }
                JsonObject rawEntity = contents.getAsJsonObject();
                Identifier entityType = Identifier.of(JsonUtils.getString(rawEntity, "type"));
                UUID uuid = UUID.fromString(JsonUtils.getString(rawEntity, "id"));
                ATextComponent name = this.textComponentSerializer.deserialize(rawEntity.get("name"));
                return new EntityHoverEvent(action, entityType, uuid, name);
            }
        }
        return null;
    }

    protected AHoverEvent deserializeLegacy(HoverEventAction action, ATextComponent text) {
        switch (action) {
            case SHOW_TEXT: {
                return new TextHoverEvent(action, text);
            }
            case SHOW_ITEM: {
                CompoundTag rawTag = (CompoundTag)this.sNbtSerializer.tryDeserialize(text.asUnformattedString());
                if (rawTag == null) {
                    return null;
                }
                Identifier id = Identifier.of(rawTag.getString("id"));
                byte count = rawTag.getByte("count");
                CompoundTag tag = null;
                if (rawTag.contains("tag", NbtType.COMPOUND)) {
                    tag = rawTag.getCompound("tag");
                }
                return new ItemHoverEvent(action, id, count, tag);
            }
            case SHOW_ENTITY: {
                try {
                    CompoundTag rawEntity = (CompoundTag)this.sNbtSerializer.deserialize(text.asUnformattedString());
                    ATextComponent name = this.textComponentSerializer.deserialize(rawEntity.getString("name"));
                    Identifier entityType = Identifier.of(rawEntity.getString("type"));
                    UUID uuid = UUID.fromString(rawEntity.getString("id"));
                    return new EntityHoverEvent(action, entityType, uuid, name);
                }
                catch (JsonSyntaxException | SNbtDeserializeException ignored) {
                    return null;
                }
            }
        }
        return null;
    }
}

