/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.text.serializer.v1_16;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import net.lenni0451.mcstructs.text.ATextComponent;
import net.lenni0451.mcstructs.text.components.KeybindComponent;
import net.lenni0451.mcstructs.text.components.NbtComponent;
import net.lenni0451.mcstructs.text.components.ScoreComponent;
import net.lenni0451.mcstructs.text.components.SelectorComponent;
import net.lenni0451.mcstructs.text.components.StringComponent;
import net.lenni0451.mcstructs.text.components.TranslationComponent;
import net.lenni0451.mcstructs.text.components.nbt.BlockNbtComponent;
import net.lenni0451.mcstructs.text.components.nbt.EntityNbtComponent;
import net.lenni0451.mcstructs.text.components.nbt.StorageNbtComponent;

public class TextSerializer_v1_16
implements JsonSerializer<ATextComponent> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JsonElement serialize(ATextComponent src, Type typeOfSrc, JsonSerializationContext context) {
        JsonElement serializedStyle;
        JsonObject serializedComponent = new JsonObject();
        if (!src.getStyle().isEmpty() && (serializedStyle = context.serialize((Object)src.getStyle())).isJsonObject()) {
            JsonObject serializedStyleObject = serializedStyle.getAsJsonObject();
            for (Map.Entry entry : serializedStyleObject.entrySet()) {
                serializedComponent.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        if (!src.getSiblings().isEmpty()) {
            JsonArray siblings = new JsonArray();
            for (ATextComponent sibling : src.getSiblings()) {
                siblings.add(this.serialize(sibling, sibling.getClass(), context));
            }
            serializedComponent.add("extra", (JsonElement)siblings);
        }
        if (src instanceof StringComponent) {
            serializedComponent.addProperty("text", ((StringComponent)src).getText());
            return serializedComponent;
        } else if (src instanceof TranslationComponent) {
            Object[] args;
            TranslationComponent translationComponent = (TranslationComponent)src;
            serializedComponent.addProperty("translate", translationComponent.getKey());
            if (translationComponent.getArgs().length <= 0) return serializedComponent;
            JsonArray with = new JsonArray();
            for (Object arg : args = translationComponent.getArgs()) {
                if (arg instanceof ATextComponent) {
                    with.add(this.serialize((ATextComponent)arg, arg.getClass(), context));
                    continue;
                }
                with.add((JsonElement)new JsonPrimitive(String.valueOf(arg)));
            }
            serializedComponent.add("with", (JsonElement)with);
            return serializedComponent;
        } else if (src instanceof ScoreComponent) {
            ScoreComponent scoreComponent = (ScoreComponent)src;
            JsonObject serializedScore = new JsonObject();
            serializedScore.addProperty("name", scoreComponent.getName());
            serializedScore.addProperty("objective", scoreComponent.getObjective());
            serializedComponent.add("score", (JsonElement)serializedScore);
            return serializedComponent;
        } else if (src instanceof SelectorComponent) {
            serializedComponent.addProperty("selector", ((SelectorComponent)src).getSelector());
            return serializedComponent;
        } else if (src instanceof KeybindComponent) {
            serializedComponent.addProperty("keybind", ((KeybindComponent)src).getKeybind());
            return serializedComponent;
        } else {
            if (!(src instanceof NbtComponent)) throw new JsonParseException("Don't know how to serialize " + src + " as a Component");
            NbtComponent nbtComponent = (NbtComponent)src;
            serializedComponent.addProperty("nbt", nbtComponent.getComponent());
            serializedComponent.addProperty("interpret", Boolean.valueOf(nbtComponent.isResolve()));
            if (nbtComponent instanceof BlockNbtComponent) {
                serializedComponent.addProperty("block", ((BlockNbtComponent)nbtComponent).getPos());
                return serializedComponent;
            } else if (nbtComponent instanceof EntityNbtComponent) {
                serializedComponent.addProperty("entity", ((EntityNbtComponent)nbtComponent).getSelector());
                return serializedComponent;
            } else {
                if (!(nbtComponent instanceof StorageNbtComponent)) throw new JsonParseException("Don't know how to serialize " + src + " as a Component");
                serializedComponent.addProperty("storage", ((StorageNbtComponent)nbtComponent).getId().get());
            }
        }
        return serializedComponent;
    }
}

