/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.text.serializer.v1_19_4;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.lenni0451.mcstructs.core.Identifier;
import net.lenni0451.mcstructs.text.ATextComponent;
import net.lenni0451.mcstructs.text.Style;
import net.lenni0451.mcstructs.text.components.KeybindComponent;
import net.lenni0451.mcstructs.text.components.ScoreComponent;
import net.lenni0451.mcstructs.text.components.SelectorComponent;
import net.lenni0451.mcstructs.text.components.StringComponent;
import net.lenni0451.mcstructs.text.components.TranslationComponent;
import net.lenni0451.mcstructs.text.components.nbt.BlockNbtComponent;
import net.lenni0451.mcstructs.text.components.nbt.EntityNbtComponent;
import net.lenni0451.mcstructs.text.components.nbt.StorageNbtComponent;
import net.lenni0451.mcstructs.text.utils.JsonUtils;

public class TextDeserializer_v1_19_4
implements JsonDeserializer<ATextComponent> {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ATextComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Style newStyle;
        void var5_21;
        if (json.isJsonPrimitive()) {
            return new StringComponent(json.getAsString());
        }
        if (json.isJsonArray()) {
            void var5_7;
            JsonArray array = json.getAsJsonArray();
            Object var5_6 = null;
            for (JsonElement element : array) {
                ATextComponent serializedElement = this.deserialize(element, element.getClass(), context);
                if (var5_7 == null) {
                    ATextComponent aTextComponent = serializedElement;
                    continue;
                }
                var5_7.append(serializedElement);
            }
            return var5_7;
        }
        if (!json.isJsonObject()) throw new JsonParseException("Don't know how to turn " + json + " into a Component");
        JsonObject rawComponent = json.getAsJsonObject();
        if (rawComponent.has("text")) {
            StringComponent stringComponent = new StringComponent(JsonUtils.getString(rawComponent, "text"));
        } else if (rawComponent.has("translate")) {
            String translate = JsonUtils.getString(rawComponent, "translate");
            String fallback = JsonUtils.getString(rawComponent, "fallback");
            if (rawComponent.has("with")) {
                JsonArray with = rawComponent.getAsJsonArray("with");
                Object[] args = new Object[with.size()];
                for (int i = 0; i < with.size(); ++i) {
                    StringComponent stringComponent;
                    ATextComponent element = this.deserialize(with.get(i), typeOfT, context);
                    args[i] = element;
                    if (!(element instanceof StringComponent) || !(stringComponent = (StringComponent)element).getStyle().isEmpty() || !stringComponent.getSiblings().isEmpty()) continue;
                    args[i] = stringComponent.getText();
                }
                TranslationComponent translationComponent = new TranslationComponent(translate, fallback, args);
            } else {
                TranslationComponent translationComponent = new TranslationComponent(translate, fallback);
            }
        } else if (rawComponent.has("score")) {
            JsonObject score = rawComponent.getAsJsonObject("score");
            if (!score.has("name") || !score.has("objective")) {
                throw new JsonParseException("A score component needs at least a name and an objective");
            }
            ScoreComponent scoreComponent = new ScoreComponent(JsonUtils.getString(score, "name"), JsonUtils.getString(score, "objective"));
        } else if (rawComponent.has("selector")) {
            if (rawComponent.has("separator")) {
                SelectorComponent selectorComponent = new SelectorComponent(JsonUtils.getString(rawComponent, "selector"), this.deserialize(rawComponent.get("separator"), typeOfT, context));
            } else {
                SelectorComponent selectorComponent = new SelectorComponent(JsonUtils.getString(rawComponent, "selector"), null);
            }
        } else if (rawComponent.has("keybind")) {
            KeybindComponent keybindComponent = new KeybindComponent(JsonUtils.getString(rawComponent, "keybind"));
        } else {
            if (!rawComponent.has("nbt")) throw new JsonParseException("Don't know how to turn " + json + " into a Component");
            String nbt = JsonUtils.getString(rawComponent, "nbt");
            boolean interpret = JsonUtils.getBoolean(rawComponent, "interpret", false);
            ATextComponent separator = null;
            if (rawComponent.has("separator")) {
                separator = this.deserialize(rawComponent.get("separator"), typeOfT, context);
            }
            if (rawComponent.has("block")) {
                BlockNbtComponent blockNbtComponent = new BlockNbtComponent(nbt, interpret, separator, JsonUtils.getString(rawComponent, "block"));
            } else if (rawComponent.has("entity")) {
                EntityNbtComponent entityNbtComponent = new EntityNbtComponent(nbt, interpret, separator, JsonUtils.getString(rawComponent, "entity"));
            } else {
                if (!rawComponent.has("storage")) throw new JsonParseException("Don't know how to turn " + json + " into a Component");
                StorageNbtComponent storageNbtComponent = new StorageNbtComponent(nbt, interpret, separator, Identifier.of(JsonUtils.getString(rawComponent, "storage")));
            }
        }
        if (rawComponent.has("extra")) {
            JsonArray extra = rawComponent.getAsJsonArray("extra");
            if (extra.isEmpty()) {
                throw new JsonParseException("Unexpected empty array of components");
            }
            for (JsonElement element : extra) {
                var5_21.append(this.deserialize(element, typeOfT, context));
            }
        }
        if ((newStyle = (Style)context.deserialize((JsonElement)rawComponent, Style.class)) == null) return var5_21;
        var5_21.setStyle(newStyle);
        return var5_21;
    }
}

