/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs_bedrock.text;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public enum BedrockTextFormatting {
    BLACK("black", '0', 0),
    DARK_BLUE("dark_blue", '1', 170),
    DARK_GREEN("dark_green", '2', 43520),
    DARK_AQUA("dark_aqua", '3', 43690),
    DARK_RED("dark_red", '4', 0xAA0000),
    DARK_PURPLE("dark_purple", '5', 0xAA00AA),
    GOLD("gold", '6', 0xFFAA00),
    GRAY("gray", '7', 0xAAAAAA),
    DARK_GRAY("dark_gray", '8', 0x555555),
    BLUE("blue", '9', 0x5555FF),
    GREEN("green", 'a', 0x55FF55),
    AQUA("aqua", 'b', 0x55FFFF),
    RED("red", 'c', 0xFF5555),
    LIGHT_PURPLE("light_purple", 'd', 0xFF55FF),
    YELLOW("yellow", 'e', 0xFFFF55),
    WHITE("white", 'f', 0xFFFFFF),
    MINECOIN_GOLD("minecoin_gold", 'g', 14538245),
    MATERIAL_QUARTZ("material_quartz", 'h', 14931153),
    MATERIAL_IRON("material_iron", 'i', 0xCECACA),
    MATERIAL_NETHERITE("material_netherite", 'j', 4471355),
    MATERIAL_REDSTONE("material_redstone", 'm', 9901575),
    MATERIAL_COPPER("material_copper", 'n', 11823181),
    MATERIAL_GOLD("material_gold", 'p', 14594349),
    MATERIAL_EMERALD("material_emerald", 'q', 4694070),
    MATERIAL_DIAMOND("material_diamond", 's', 2931368),
    MATERIAL_LAPIS("material_lapis", 't', 2181499),
    MATERIAL_AMETHYST("material_amethyst", 'u', 10116294),
    OBFUSCATED("obfuscated", 'k'),
    BOLD("bold", 'l'),
    ITALIC("italic", 'o'),
    RESET("reset", 'r');

    public static final Map<String, BedrockTextFormatting> ALL;
    public static final Map<String, BedrockTextFormatting> COLORS;
    public static final Map<String, BedrockTextFormatting> FORMATTINGS;
    public static final char COLOR_CHAR = '\u00a7';
    private final Type type;
    private final String name;
    private final char code;
    private final int rgbValue;

    @Nullable
    public static BedrockTextFormatting getByOrdinal(int ordinal) {
        for (BedrockTextFormatting formatting : BedrockTextFormatting.values()) {
            if (formatting.ordinal() != ordinal) continue;
            return formatting;
        }
        return null;
    }

    @Nullable
    public static BedrockTextFormatting getByName(String name) {
        return ALL.get(name.toLowerCase());
    }

    @Nullable
    public static BedrockTextFormatting getByCode(char code) {
        for (BedrockTextFormatting formatting : BedrockTextFormatting.values()) {
            if (formatting.getCode() != code) continue;
            return formatting;
        }
        return null;
    }

    public static BedrockTextFormatting getClosestFormattingColor(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        BedrockTextFormatting closest = null;
        int closestDistance = Integer.MAX_VALUE;
        for (BedrockTextFormatting color : COLORS.values()) {
            int colorB;
            int colorG;
            int colorR = color.getRgbValue() >> 16 & 0xFF;
            int distance = (r - colorR) * (r - colorR) + (g - (colorG = color.getRgbValue() >> 8 & 0xFF)) * (g - colorG) + (b - (colorB = color.getRgbValue() & 0xFF)) * (b - colorB);
            if (distance >= closestDistance) continue;
            closest = color;
            closestDistance = distance;
        }
        return closest;
    }

    private BedrockTextFormatting(String name, char code, int rgbValue) {
        this.type = Type.COLOR;
        this.name = name;
        this.code = code;
        this.rgbValue = rgbValue;
    }

    private BedrockTextFormatting(String name, char code) {
        this.type = Type.FORMATTING;
        this.name = name;
        this.code = code;
        this.rgbValue = -1;
    }

    public boolean isColor() {
        return Type.COLOR.equals((Object)this.type);
    }

    public boolean isFormatting() {
        return Type.FORMATTING.equals((Object)this.type);
    }

    public String getName() {
        return this.name;
    }

    public char getCode() {
        return this.code;
    }

    public int getRgbValue() {
        return this.rgbValue;
    }

    static {
        ALL = new LinkedHashMap<String, BedrockTextFormatting>();
        COLORS = new LinkedHashMap<String, BedrockTextFormatting>();
        FORMATTINGS = new LinkedHashMap<String, BedrockTextFormatting>();
        for (BedrockTextFormatting formatting : BedrockTextFormatting.values()) {
            ALL.put(formatting.getName(), formatting);
            if (formatting.isColor()) {
                COLORS.put(formatting.getName(), formatting);
                continue;
            }
            if (formatting.isFormatting()) {
                FORMATTINGS.put(formatting.getName(), formatting);
                continue;
            }
            throw new IllegalStateException("Formatting " + formatting.name() + " is neither a color nor a formatting");
        }
    }

    private static enum Type {
        COLOR,
        FORMATTING;

    }
}

