/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs_bedrock.text.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.lenni0451.mcstructs_bedrock.text.ABedrockComponent;

public class RootBedrockComponent
extends ABedrockComponent {
    private final List<ABedrockComponent> components;

    public RootBedrockComponent() {
        this.components = new ArrayList<ABedrockComponent>();
    }

    public RootBedrockComponent(ABedrockComponent ... components) {
        this.components = new ArrayList<ABedrockComponent>();
        this.components.addAll(Arrays.asList(components));
    }

    public RootBedrockComponent(List<ABedrockComponent> components) {
        this.components = components;
    }

    public List<ABedrockComponent> getComponents() {
        return this.components;
    }

    public RootBedrockComponent addComponent(ABedrockComponent component) {
        this.components.add(component);
        return this;
    }

    public RootBedrockComponent forEach(Consumer<ABedrockComponent> consumer) {
        consumer.accept(this);
        for (ABedrockComponent component : this.components) {
            if (component instanceof RootBedrockComponent) {
                ((RootBedrockComponent)component).forEach(consumer);
                continue;
            }
            consumer.accept(component);
        }
        return this;
    }

    @Override
    public String asString() {
        StringBuilder out = new StringBuilder();
        for (ABedrockComponent component : this.components) {
            out.append(component.asString());
        }
        return out.toString();
    }

    @Override
    public ABedrockComponent copy() {
        RootBedrockComponent out = new RootBedrockComponent();
        for (ABedrockComponent component : this.components) {
            out.addComponent(component.copy());
        }
        return out;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RootBedrockComponent that = (RootBedrockComponent)o;
        return Objects.equals(this.components, that.components);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.components);
    }

    @Override
    public String toString() {
        return "RootBedrockComponent{components=" + this.components + '}';
    }
}

