/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs_bedrock.text.serializer.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.lenni0451.mcstructs_bedrock.text.ABedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.components.RootBedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.components.ScoreBedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.components.StringBedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.components.TranslationBedrockComponent;

public class BedrockTextDeserializer
implements JsonDeserializer<RootBedrockComponent> {
    public RootBedrockComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Json element is not an object");
        }
        JsonObject ob = json.getAsJsonObject();
        RootBedrockComponent root = new RootBedrockComponent();
        if (!ob.has("rawtext")) {
            throw new JsonParseException("Json object does not contain a rawtext array");
        }
        if (!ob.get("rawtext").isJsonArray()) {
            throw new JsonParseException("Json object rawtext is not an array");
        }
        JsonArray rawtext = ob.get("rawtext").getAsJsonArray();
        for (JsonElement element : rawtext) {
            if (!element.isJsonObject()) {
                throw new JsonParseException("Json element in rawtext array is not an object");
            }
            JsonObject sibling = element.getAsJsonObject();
            root.addComponent(this.deserialize(sibling, context));
        }
        return root;
    }

    private ABedrockComponent deserialize(JsonObject json, JsonDeserializationContext context) {
        if (json.has("rawtext")) {
            return this.deserialize((JsonElement)json, (Type)((Object)RootBedrockComponent.class), context);
        }
        if (json.has("translate")) {
            String key = json.get("translate").getAsString();
            ArrayList<Object> args = new ArrayList<Object>();
            if (json.has("with")) {
                if (json.get("with").isJsonObject()) {
                    RootBedrockComponent root = this.deserialize((JsonElement)json.get("with").getAsJsonObject(), (Type)((Object)RootBedrockComponent.class), context);
                    args.addAll(root.getComponents());
                } else if (json.get("with").isJsonArray()) {
                    JsonArray with = json.getAsJsonArray("with");
                    for (JsonElement element : with) {
                        if (!element.isJsonPrimitive() && !element.getAsJsonPrimitive().isString()) continue;
                        args.add(element.getAsString());
                    }
                } else {
                    throw new JsonParseException("Json element with is not an object or an array");
                }
            }
            return new TranslationBedrockComponent(key, args);
        }
        if (json.has("text")) {
            return new StringBedrockComponent(json.get("text").getAsString());
        }
        if (json.has("score")) {
            if (!json.get("score").isJsonObject()) {
                throw new JsonParseException("Json element score is not an object");
            }
            JsonObject score = json.getAsJsonObject("score");
            if (!score.has("name")) {
                throw new JsonParseException("Json object score does not contain a name");
            }
            if (!score.has("objective")) {
                throw new JsonParseException("Json object score does not contain a objective");
            }
            if (!score.get("name").isJsonPrimitive()) {
                throw new JsonParseException("Json object score name is not a primitive");
            }
            if (!score.get("objective").isJsonPrimitive()) {
                throw new JsonParseException("Json object score objective is not a primitive");
            }
            return new ScoreBedrockComponent(score.get("name").getAsString(), score.get("objective").getAsString());
        }
        if (json.has("selector")) {
            if (!json.get("selector").isJsonPrimitive()) {
                throw new JsonParseException("Json element selector is not a primitive");
            }
            return new StringBedrockComponent(json.get("selector").getAsString());
        }
        throw new JsonParseException("Json object does not contain a translate, text, score or selector");
    }
}

