/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs_bedrock.text.serializer.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.lenni0451.mcstructs_bedrock.text.ABedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.components.RootBedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.components.ScoreBedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.components.SelectorBedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.components.StringBedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.components.TranslationBedrockComponent;

public class BedrockTextSerializer
implements JsonSerializer<ABedrockComponent> {
    public JsonElement serialize(ABedrockComponent src, Type typeOfSrc, JsonSerializationContext context) {
        if (src instanceof RootBedrockComponent) {
            RootBedrockComponent root = (RootBedrockComponent)src;
            JsonArray rawtext = new JsonArray();
            for (ABedrockComponent component : root.getComponents()) {
                rawtext.add(this.serialize(component, component.getClass(), context));
            }
            JsonObject serialized = new JsonObject();
            serialized.add("rawtext", (JsonElement)rawtext);
            return serialized;
        }
        if (src instanceof StringBedrockComponent) {
            StringBedrockComponent string = (StringBedrockComponent)src;
            JsonObject serialized = new JsonObject();
            serialized.addProperty("text", string.getText());
            return serialized;
        }
        if (src instanceof TranslationBedrockComponent) {
            TranslationBedrockComponent translation = (TranslationBedrockComponent)src;
            RootBedrockComponent with = new RootBedrockComponent();
            for (Object arg : translation.getArgs()) {
                if (arg instanceof ABedrockComponent) {
                    with.addComponent((ABedrockComponent)arg);
                    continue;
                }
                with.addComponent(new StringBedrockComponent(arg.toString()));
            }
            JsonObject serialized = new JsonObject();
            serialized.addProperty("translate", translation.getKey());
            serialized.add("with", this.serialize(with, with.getClass(), context));
            return serialized;
        }
        if (src instanceof ScoreBedrockComponent) {
            ScoreBedrockComponent score = (ScoreBedrockComponent)src;
            JsonObject scoreJson = new JsonObject();
            scoreJson.addProperty("name", score.getName());
            scoreJson.addProperty("objective", score.getObjective());
            JsonObject serialized = new JsonObject();
            serialized.add("score", (JsonElement)scoreJson);
            return serialized;
        }
        if (src instanceof SelectorBedrockComponent) {
            SelectorBedrockComponent selector = (SelectorBedrockComponent)src;
            JsonObject serialized = new JsonObject();
            serialized.addProperty("selector", selector.getSelector());
            return serialized;
        }
        throw new IllegalArgumentException("Unknown component type: " + src.getClass().getName());
    }
}

